package com.digiwin.metadatacache.enums;

/**
 * 快取前缀枚举类
 */
public enum CacheMapTypeEnum implements GenericStateEnum {

    /**
     * API元数据缓存
     */
    api_metadata_cachemap("espmdc:api:metadata"),

    /**
     * 租户服务分派咨询
     */
    tenant_product_dispatch_cachemap("espmdc:product:dispatch2"),

    /**
     * 租户产品运营单元
     */
    tenant_product_operation_cachemap("espmdc:product:operation2"),

    /**
     * 租户产品清单
     */
    tenant_product_mapping_list("espmdc:product:mapping"),

    /**
     * om单元对应租户ID
     */
    om_tenant_cachemap("espmdc:om:tenant2"),

    /**
     * 租户的全域管理参数值
     */
    global_param_cachemap("espmdc:global:param2"),

    /**
     * 云地中台同步产品清单
     */
    tenant_product_list_update_cachemap("espmdc:product:update"),

    /**
     * API版本
     */
    api_version_list("espmdc:api:version"),

    /**
     * api基础信息-本地快取
     */
    api_base_info_cachemap("espmdc:api:info"),

    /**
     * api父子关系与基本信息,是否幂等
     */
    api_relation_idempotency_cachemap("espmdc:relation:relation");

    private final String code;

    CacheMapTypeEnum(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return code;
    }
}