package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据模型
 */
@Entity
@Data
@Table(name = "asset_data_model")
public class AssetDataModel implements Serializable {

    /**
     * 主键Id
     */
    @Id
    private Long id;

    /**
     * 模型编号
     */
    @Column(name = "code")
    private String code;

    /**
     * 模型名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 表
     */
    @Column(name = "tables")
    private String tables;

    /**
     * 关系
     */
    @Column(name = "links")
    private String links;

    /**
     * 模型类型(1：普通模型，2：可引用模型)
     */
    @Column(name = "type")
    private String type;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
