package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 行业术语参照表
 */
@Entity
@Data
@Table(name = "asset_industry_term")
public class AssetIndustryTerm implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "industry_term_id")
    private Long industryTermId;

    /**
     * 行业主键
     */
    @Column(name = "industry_id")
    private Long industryId;

    /**
     * 行业术语_繁体
     */
    @Column(name = "industry_term_zh_tw")
    private String industryTermZhTw;

    /**
     * 行业术语_简体
     */
    @Column(name = "industry_term_zh_cn")
    private String industryTermZhCn;

    /**
     * 行业术语_英文
     */
    @Column(name = "industry_term_en_us")
    private String industryTermEnUs;

    /**
     * 描述_繁体
     */
    @Column(name = "description_zh_tw")
    private String descriptionZhTw;

    /**
     * 描述_简体
     */
    @Column(name = "description_zh_cn")
    private String descriptionZhCn;

    /**
     * 描述_英文
     */
    @Column(name = "description_en_us")
    private String descriptionEnUs;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
