package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 资产表
 */
@Data
@Entity
@Table(name = "asset_property")
public class AssetProperty implements Serializable {

    /**
     * 主键Id
     */
    @Id
    private Long id;

    /**
     * 资产标识符
     */
    @Column(name = "code")
    private String code;

    /**
     * 资产名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 资产主键Id
     */
    @Column(name = "property_key")
    private String propertyKey;

    /**
     * 资产来源 (bm：业务服务,bmd：数据服务,dmp：数据中台)
     */
    @Column(name = "property_source")
    private String propertySource;

    /**
     * 资产归属(BM-SDSC：销售领域,BM-POSC：采购领域)
     */
    @Column(name = "owner_product")
    private String ownerProduct;

    /**
     * 资产分类(API:API,BusinessDataModel：业务数据模型,QueryProject：查询方案)
     */
    @Column(name = "property_type")
    private String propertyType;

    /**
     * 租户Id
     */
    @Column(name = "tenant_id")
    private String tenantId;

    /**
     * 资产描述
     */
    @Column(name = "property_comment")
    private String propertyComment;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
