package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据标准-业务类型
 */
@Entity
@Data
@Table(name = "asset_standard_businesstype")
public class AssetStandardBusinessType implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 业务类型编号
     */
    @Column(name = "code")
    private String code;

    /**
     * 业务类型名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 多语言
     */
    @Column(name = "lang")
    private String lang;

    /**
     * 数据类型
     */
    @Column(name = "data_type")
    private String dataType;

    /**
     * 长度
     */
    @Column(name = "size")
    private String size;

    /**
     * 精度
     */
    @Column(name = "field_precision")
    private String fieldPrecision;

    /**
     * 生失效状态(Y生效,N失效)
     */
    @Column(name = "manage_status")
    private String manage_Status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
