package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据标准-下拉辞汇
 */
@Entity
@Data
@Table(name = "asset_standard_dictionary")
public class AssetStandardDictionary implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 下拉辞汇key
     */
    @Column(name = "dictionary_key")
    private String dictionaryKey;

    /**
     * 下拉辞汇名称
     */
    @Column(name = "description")
    private String description;

    /**
     * 下拉辞汇值
     */
    @Column(name = "dictionary_values")
    private String dictionaryValues;

    /**
     * 下拉辞汇描述多语言
     */
    @Column(name = "lang")
    private String lang;

    /**
     * 标准(Y标准,N非标)
     */
    @Column(name = "standard")
    private String standard;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
