package com.digiwin.metadatacache.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * The persistent class for the StateCode database table.
 * 
 */
@Entity
@Table(name = "state_code")
public class StateCode implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "code", unique = true, nullable = false)
	private String code;

	private String description;
	@Column(name = "description_zh_cn")

	private String descriptionZhCn;
	@Column(name = "description_en_us")
	private String descriptionEnUs;

	public StateCode() {
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescriptionZhCn() {
		return descriptionZhCn;
	}

	public void setDescriptionZhCn(String description_zh_cn) {
		this.descriptionZhCn = description_zh_cn;
	}

	public String getDescriptionEnUs() {
		return descriptionEnUs;
	}

	public void setDescriptionEnUs(String description_en_us) {
		this.descriptionEnUs = description_en_us;
	}

}