package com.digiwin.metadatacache.rest.impl;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.metadatacache.apiservice.*;
import com.digiwin.metadatacache.rest.IMetadataCacheService;
import lombok.extern.apachecommons.CommonsLog;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * Metadata Cache接口服務
 */
@CommonsLog
public class MetadataCacheService implements IMetadataCacheService {

	/**
	 * 取得API清单
	 */
	@Autowired
	private ApiListGetService apiListGetService;

	/**
	 * 取得API元数据
	 */
	@Autowired
	private ApiMetadataGetService apiMetadataGetService;
	@Autowired
	private ApiMetadataGetByApiService apiMetadataGetByApiService;

	/**
	 * 取得租户产品清单
	 */
	@Autowired
	private TenantProductListGetService tenantProductListGetService;

	/**
	 * 取得租户地中台咨询
	 */
	@Autowired
	private TenantEaiInfoGetService tenantEaiInfoGetService;

	/**
	 * 取得租户服务分派咨询
	 */
	@Autowired
	private TenantProductInfoGetService tenantProductInfoGetService;

	/**
	 * 保存租户服务信息
	 */
	@Autowired
	private ProductInfoAddService productInfoAddService;

	/**
	 * 取得运营单元转换咨询
	 */
	@Autowired
	private TenantOrganizationTransGetService tenantOrganizationTransGetService;

	/**
	 * 取得租户的EOC清单
	 */
	@Autowired
	private EocInfoGetService eocInfoGetService;

	/**
	 * 取得租户的EOC清单
	 */
	@Autowired
	private EocInfoV2GetService eocInfoV2GetService;

	/**
	 * 取得稳态产品om清单
	 */
	@Autowired
	private IntgInfoGetService intgInfoGetService;

	/**
	 * 取得租户产品运营清单(含运营阶层关系)
	 */
	@Autowired
	private TenantProductOperationListGetService tenantProductOperationListGetService;

	/**
	 * 取得租户的全域管理参数值
	 */
	@Autowired
	private GlobalParamsGetService globalParamsGetService;

	/**
	 * 取得自动配对EOC运营单元码清单
	 */
	@Autowired
	private DefaultEocMappingGetService defaultEocMappingGetService;

	/**
	 * 取得om单元对应租户ID
	 */
	@Autowired
	private OmTenantIdGetService omTenantIdGetService;

	/**
	 * 清cache
	 */
	@Autowired
	private CleanCacheService cleanCacheService;

	/**
	 * show cache
	 */
	@Autowired
	private ShowCacheService showCacheService;

	/**
	 * 刪除API元数据(DSMS同步用)
	 */
	@Autowired
	private StdApiMetadataDeleteService stdApiMetadataDeleteService;

	/**
	 * 云中台整合设定同步产品清单
	 */
	@Autowired
	private TenantProductListUpdateService tenantProductListUpdateService;

	/**
	 * 同步eoc与om代码对应
	 */
	@Autowired
	private EOCIntgMapUpdateService eocIntgMapUpdate;

	/**
	 * 取得租户稳态产品支持的应用版本
	 */
	@Autowired
	private AppSupportListGetService appSupportListGetService;

	/**
	 * 查询支持应用版本的租户
	 */
	@Autowired
	private AppSupportVersionGetService appSupportVersionGetService;

	/**
	 * 新增/修改租户稳态产品支持的应用版本
	 */
	@Autowired
	private AppSupportVersionAddService appSupportVersionAddService;

	/**
	 * 取得产品主机的运营配置
	 */
	@Autowired
	private OperationManageSettingGetService operationManageSettingGetService;

	/**
	 * 启用|禁用运营单元配置
	 */
	@Autowired
	private OperationManageSettingUpdateService operationManageSettingUpdateService;

	/**
	 * 取得租户运营配置状况
	 */
	@Autowired
	private EocSetInfoCheckService eocSetInfoCheckService;

	/**
	 * 取得租户忽略运营配置状况
	 */
	@Autowired
	private IgnoreEocSetService ignoreEocSetService;

	/**
	 * 取得新增或修改的API清单
	 */
	@Autowired
	private ApiInfoGet apiInfoGet;

	/**
	 * 取得拥有个案api的租户列表
	 */
	@Autowired
	private UcTenantListGetService ucTenantListGetService;

	/**
	 * 取得租户ERP产品主机
	 */
	@Autowired
	private TenantProductTypeGetService tenantProductTypeGetService;

	/**
	 * 查询租户所有可调用的产品
	 */
	@Autowired
	private TenantBindProductListGetService tenantBindProductListGetService;

	/**
	 * 取得租户服务分派咨询(新增服务名称，用来判定是否需要分派)
	 */
	@Autowired
	private TenantProductApiDispatchInfoGetService tenantProductApiDispatchInfoGetService;

	/**
	 * 取得API provider
	 */
	@Autowired
	private ApiProviderGetService apiProviderGetService;

	/**
	 * API 与那数据更新
	 */
	@Autowired
	private StdApiMetadataUpdateService stdApiMetadataUpdateService;

	/**
	 * API 映射关系 查询
	 */
	@Autowired
	private ApiRelationGetService apiRelationGetService;

	/**
	 * API 映射关系 保存
	 */
	@Autowired
	private ApiRelationSaveService apiRelationSaveService;

	/**
	 * API 映射关系 删除
	 */
	@Autowired
	private ApiRelationDeleteService apiRelationDeleteService;

	/**
	 * API基础信息
	 */
	@Autowired
	private ApiBaseInfoGetService apiBaseInfoGetService;

	/**
	 * 资产注册
	 */
	@Autowired
	private AssetRegisterService assetRegisterService;

	/**
	 * 获取行业辞汇清单
	 */
	@Autowired
	private AssetIndustryVocabularyListGetService assetIndustryVocabularyListGetService;

	/**
	 * 获取资产清单
	 */
	@Autowired
	private AssetListGetService assetListGetService;

	@Autowired
	private TenantApiProductListGetService tenantApiProductListGetService;

	@Autowired
	private ServiceBaseInfoGetService serviceBaseInfoGetService;

	@Autowired
	private TenantProductCloudMappingGetService tenantProductCloudMappingGetService;


	@Autowired
	private CloudMappingSettingGetService cloudMappingSettingGetService;

	@Autowired
	private CloudMappingSettingUpdateService cloudMappingSettingUpdateService;

	@Autowired
	private CloudRegionMappingUpdateService cloudRegionMappingUpdateService;

	@Autowired
	private CloudRegionMappingGetService cloudRegionMappingGetService;

	@Autowired
	private TenantProductOperationListV2GetService tenantProductOperationListV2GetService;

	@Autowired
	private TenantInfoGetService tenantInfoGetService;

	/**
	 * 取得API清单
	 */
	@Override
	public Map<String, Object> apiListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		log.info("apiListGet —— token: " + DWServiceContext.getContext().getRequestHeader().get("token"));
		DWServiceContext.getContext().setStandardResult(false);
		return apiListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得API元数据
	 */
	@Override
	public Map<String, Object> apiMetadataGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiMetadataGetService.execute(request.getBodyAsString());
	}
	
	@Override
	public Map<String, Object> apiMetadataGetByApi(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiMetadataGetByApiService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租户产品清单
	 */
	@Override
	public Map<String, Object> tenantProductListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶服務分派資訊
	 */
	@Override
	public Map<String, Object> tenantProductListDispatchInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductInfoGetService.execute(request.getBodyAsString());
	}

	/**
	 * 保存租戶服务信息
	 */
	@Override
	public Map<String, Object> productInfoAdd(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return productInfoAddService.execute(request.getBodyAsString());
	}

	/**
	 * 取得運營單元轉換資訊
	 */
	@Override
	public Map<String, Object> tenantOrganizationTransGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantOrganizationTransGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租户的EOC清单
	 */
	@Override
	public Map<String, Object> eocInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return eocInfoGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得稳态产品om清單
	 */
	@Override
	public Map<String, Object> intgInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return intgInfoGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶產品運營清單(含運營階層關係)
	 */
	@Override
	public Map<String, Object> tenantProductOperationListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductOperationListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶的全域管理參數值
	 */
	@Override
	public Map<String, Object> globalParamsGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return globalParamsGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得自動配對EOC運營單元碼清單
	 */
	@Override
	public Map<String, Object> defaultEocMappingGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return defaultEocMappingGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得om單元對應租戶ID
	 */
	@Override
	public Map<String, Object> omTenantIdGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return omTenantIdGetService.execute(request.getBodyAsString());
	}

	/**
	 * 清cache
	 */
	@Override
	public Map<String, Object> cleanCache(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return cleanCacheService.execute(request.getBodyAsString());
	}

	/**
	 * show cache
	 */
	@Override
	public Map<String, Object> showCache(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return showCacheService.execute(request.getBodyAsString());
	}

	/**
	 * 刪除API元數據(DSMS同步用)
	 */
	@Override
	public Map<String, Object> stdApiMetadataDelete(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return stdApiMetadataDeleteService.execute(request.getBodyAsString());
	}

	/**
	 * 雲中台整合設定同步產品清單
	 */
	@Override
	public Map<String, Object> tenantProductListUpdate(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductListUpdateService.execute(request.getBodyAsString());
	}

	/**
	 * 同步eoc與om代碼對應
	 */
	@Override
	public Map<String, Object> eocIntgMapUpdate(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return eocIntgMapUpdate.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶穩態產品支持的應用版本
	 */
	@Override
	public Map<String, Object> appSupportListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return appSupportListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 查詢支持應用版本的租戶
	 */
	@Override
	public Map<String, Object> appSupportVersionGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return appSupportVersionGetService.execute(request.getBodyAsString());
	}

	/**
	 * 新增/修改租戶穩態產品支持的應用版本
	 */
	@Override
	public Map<String, Object> appSupportVersionAdd(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return appSupportVersionAddService.execute(request.getBodyAsString());
	}

	/**
	 * 取得產品主機的運營配置
	 */
	@Override
	public Map<String, Object> operationManageSettingGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return operationManageSettingGetService.execute(request.getBodyAsString());
	}

	/**
	 * 啟用/禁用運營單元配置
	 */
	@Override
	public Map<String, Object> operationManageSettingUpdate(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return operationManageSettingUpdateService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶地中台資訊
	 */
	@Override
	public Map<String, Object> tenantEaiInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantEaiInfoGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得新增或修改的API清單
	 */
	@Override
	public Map<String, Object> apiInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiInfoGet.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶運營配置狀況
	 */
	@Override
	public Map<String, Object> eocSetInfoCheck(DWRestfulRequest request) throws Exception {
		return eocSetInfoCheckService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶忽略運營配置狀況
	 */
	@Override
	public Map<String, Object> ignoreEocSetInfo(DWRestfulRequest request) throws Exception {
		return ignoreEocSetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得拥有个案api的租户列表
	 */
	@Override
	public Map<String, Object> ucTenantListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return ucTenantListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶ERP產品主機
	 */
	@Override
	public Map<String, Object> tenantProductTypeGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductTypeGetService.execute(request.getBodyAsString());
	}

	/**
	 * 查詢租戶所有可調用的產品
	 */
	@Override
	public Map<String, Object> tenantBindProductListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantBindProductListGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得租戶服務分派資訊(新增服務名稱，用來判斷是否需要分派)
	 */
	@Override
	public Map<String, Object> tenantProductApiDispatchInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductApiDispatchInfoGetService.execute(request.getBodyAsString());
	}

	/**
	 * 取得API provider
	 */
	@Override
	public Map<String, Object> apiProviderGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiProviderGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> StdApiMetadataUpdate(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return stdApiMetadataUpdateService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> ApiRelationGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiRelationGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> ApiRelationSave(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiRelationSaveService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> ApiRelationDelete(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiRelationDeleteService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> ApiBaseInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return apiBaseInfoGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> assetRegister(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return assetRegisterService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> assetListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return assetListGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> assetIndustryVocabularyListGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return assetIndustryVocabularyListGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> batchGetTenantApiProduct(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantApiProductListGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> getServiceBaseInfo(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return serviceBaseInfoGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> tenantProductCloudMappingGet (DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductCloudMappingGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> cloudMappingSettingGet (DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return cloudMappingSettingGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> cloudMappingSettingUpdate (DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return cloudMappingSettingUpdateService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> cloudRegionMappingUpdate(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return cloudRegionMappingUpdateService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> cloudRegionMappingGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return cloudRegionMappingGetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> getEOCInfoV2Get(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return eocInfoV2GetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> tenantProductOperationListV2Get(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantProductOperationListV2GetService.execute(request.getBodyAsString());
	}

	@Override
	public Map<String, Object> getTenantInfoGet(DWRestfulRequest request) throws Exception {
		// 設定Response Body非DAP標準格式
		DWServiceContext.getContext().setStandardResult(false);
		return tenantInfoGetService.execute(request.getBodyAsString());
	}
}
