package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.constant.InterfaceConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.enums.EocOperationTypeEnum;
import com.digiwin.metadatacache.exception.*;
import com.digiwin.metadatacache.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.net.URI;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

@Service
public class EocInfoService {

    private final Log log = LogFactory.getLog(getClass());

    ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private DWHttpClient dwHttpClient;

    @Value("${iamApToken}")
    private String iamApToken;

    /**
     * 根據租戶ID取得EOC運營單元碼
     */
    public ObjectNode getEocInfoByTenantId(String pTenantId) throws Exception {
        // 根據license key呼叫IAM取得userToken
        String tToken = getTokenByTenant(pTenantId);
        // 根據userToken呼叫EOC取得運營單元碼
        return getEocInfoByUserToken(tToken);
    }

    /**
     * 根據租戶ID取得EOC運營單元碼(雲地映射)
     */
    public ObjectNode getEocInfoV2ByTenantId(String pTenantId) throws Exception {
        // 根據license key呼叫IAM取得userToken
        String tToken = getTokenByTenant(pTenantId);
        // 根據userToken呼叫EOC取得運營單元碼
        return getEocInfoV2ByUserToken(tToken);
    }



    /**
     * 根據license key呼叫IAM取得userToken
     */
    @SuppressWarnings("unchecked")
    private String getTokenByTenant(String tenantId) throws Exception {
        try {
            URI tIamTargetUri = DWURIBuilder.create("iam", InterfaceConstant.IAM_LOGIN_INTERNAL).build();
            HttpPost tPost = new HttpPost(tIamTargetUri);
            Map<String, Object> tRequestEntity = new HashMap<>();
            tRequestEntity.put("identityType", "internal");
            tRequestEntity.put("userId", "integration");
            tRequestEntity.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
            tRequestEntity.put("tenantId", tenantId);
            tPost.setEntity(new DWJsonEntity(tRequestEntity));
            tPost.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tPost.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            Map<String, Object> tResponseEntity = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));
            return (String) tResponseEntity.get(MdcConstant.TOKEN);
        } catch (DWHttpFailedException e) {
            Map<String, Object> tFailedEntity = e.getEntity(Map.class);
            String tMsg = String.format("IAM response: %s", tFailedEntity.get("message"));
            throw new TokenNotRetrievedException(tMsg, getClass());
        } catch (Exception e) {
            throw new TokenNotRetrievedException(e, getClass());
        }
    }


    /**
     * 根據userToken呼叫EOC取得運營單元碼
     */
    public ObjectNode getEocInfoByUserToken(String pToken) throws Exception {
        try {
            log.info("根據token：" + pToken + "取得EOC資訊");
            URI tTargetUri = DWURIBuilder.create("eoc", InterfaceConstant.EOC_CORP_ALL).build();
            HttpGet tGet = new HttpGet(tTargetUri);
            tGet.addHeader(MdcConstant.TOKEN, pToken);
            tGet.addHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pToken);
            tGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tGet.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String tResponseEntity = dwHttpClient.execute(tGet, String.class, new DWRequestOption(false));
            ObjectNode tTotalEocNode = (ObjectNode) mapper.readTree(tResponseEntity);
            log.info("取得EOC資訊：" + tTotalEocNode.toString());
            return tTotalEocNode;
        } catch (DWHttpFailedException e) {
            Map<String, Object> tFailedEntity = e.getEntity(Map.class);
            String tMsg = String.format("Eoc response: %s", tFailedEntity.get("message"));
            throw new EocFailedException(tMsg, getClass());
        } catch (Exception e) {
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                throw new EocFailedException(e.getMessage(), getClass());
            } else {
                throw new EocFailedException(e.getCause(), getClass());
            }
        }
    }

    /**
     * 根據userToken呼叫EOC取得運營單元碼(雲地映射)
     */
    public ObjectNode getEocInfoV2ByUserToken(String pToken) throws Exception {
        try {
            log.info("method=getEocInfoV2ByUserToken,根據token：" + pToken + "取得EOC資訊");
            URI tTargetUri = DWURIBuilder.create("eoc", InterfaceConstant.EOC_V2_CORP_ALL)
                                         .addParameter("status",true).build();
            HttpGet tGet = new HttpGet(tTargetUri);
            tGet.addHeader(MdcConstant.TOKEN, pToken);
            tGet.addHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pToken);
            tGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tGet.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String tResponseEntity = dwHttpClient.execute(tGet, String.class, new DWRequestOption(false));
            ObjectNode tTotalEocNode = (ObjectNode) mapper.readTree(tResponseEntity);
            log.info("method=getEocInfoV2ByUserToken,取得EOC資訊：" + tTotalEocNode.toString());
            return tTotalEocNode;
        } catch (DWHttpFailedException e) {
            Map<String, Object> tFailedEntity = e.getEntity(Map.class);
            String tMsg = String.format("Eoc response: %s", tFailedEntity.get("message"));
            throw new EocFailedException(tMsg, getClass());
        } catch (Exception e) {
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                throw new EocFailedException(e.getMessage(), getClass());
            } else {
                throw new EocFailedException(e.getCause(), getClass());
            }
        }
    }

    /**
     * 新增修改刪除雲控制台eoc運營單元
     * 執行刪除才需要提供sid，其餘操作不需要
     * 工廠的level和typeSid皆為3，公司為2
     * state = 0為新增 state = 1為刪除
     **/
    public String updateEocEntry(String pSid, String pEocId, String pToken, int pLevel, int pTypeSid,
                                  String pParentSid, int pState) throws Exception {
        try {
            URI tEocTargetUri = DWURIBuilder.create(MdcApplicationParameter._EOC_HOST + InterfaceConstant.UPDATE_EOC_ENTRY).build();
            HttpPost tPost = new HttpPost(tEocTargetUri);
            ObjectNode objectNode = mapper.createObjectNode();
            // 公司
            if (pLevel == 2) {
                objectNode.put("sid", pSid);
                objectNode.put("id", pEocId);
                objectNode.put("name", pEocId);
                objectNode.put("typeSid", pTypeSid);
                objectNode.put("parentSid", pParentSid);
                objectNode.put("level", pLevel);
                // 工廠
            } else if (pLevel == 3) {
                objectNode.put("level", pLevel);
                ArrayNode arrayNode = mapper.createArrayNode();
                objectNode.set(MdcConstant.FACTORIES, arrayNode);
                ObjectNode siteNode = mapper.createObjectNode();
                siteNode.put("sid", pSid);
                siteNode.put("id", pEocId);
                siteNode.put("name", pEocId);
                siteNode.put("typeSid", pTypeSid);
                siteNode.put("parentSid", pParentSid);
                siteNode.put("level", pLevel);
                siteNode.put("state", pState);
                arrayNode.add(siteNode);
            }
            StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
            entity.setContentEncoding("UTF-8");
            tPost.setEntity(entity);
            tPost.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pToken);
            tPost.setHeader(MdcConstant.TOKEN, pToken);
            tPost.setHeader(MdcConstant.CONTENT_TYPE, MdcConstant.APPLICATION_JSON);
            tPost.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tPost.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String result = dwHttpClient.execute(tPost, String.class, new DWRequestOption(false));
            JsonNode tResultNode = mapper.readTree(result);
            String tOperation = "";
            if (pLevel == 2) {
                if (pState == 0) {
                    tOperation = EocOperationTypeEnum.add.toString();
                    log.info("新增雲控制台公司層級eoc：" + pEocId + result);
                }
            } else if (pLevel == 3) {

                if (pState == 0) {
                    tOperation = EocOperationTypeEnum.add.toString();
                    log.info("新增雲控制台工廠層級eoc：" + pEocId + result);
                } else if (pState == 1) {
                    tOperation = EocOperationTypeEnum.delete.toString();
                    log.info("刪除雲控制台工廠層級eoc：" + pEocId + result);
                }
            }
            if (tResultNode.get(MdcConstant.CODE) == null || !tResultNode.get(MdcConstant.CODE).asText().matches("200")) {
                if (tOperation.equals(EocOperationTypeEnum.add.toString())) {
                    throw new UpdateEocFailedException(tResultNode.get(MdcConstant.ERRORMESSAGE).asText(), getClass());
                } else if (tOperation.equals(EocOperationTypeEnum.delete.toString())) {
                    throw new DeleteCompanyEocFailedException(tResultNode.get(MdcConstant.ERRORMESSAGE).asText(), getClass());
                }
            }
            return result;
        } catch (UpdateEocFailedException e) {
            throw e;
        } catch (Exception e) {
            throw new UpdateEocFailedException(e.getMessage(), getClass());
        }
    }

    /**
     * 获取集团信息
     *
     * @param pToken pToken
     * @return String
     * @throws Exception Exception
     */
    public String getEnterPriseSid(String pToken) throws Exception {
        try {
            URI tEocTargetUri = DWURIBuilder.create(MdcApplicationParameter._EOC_HOST + InterfaceConstant.GET_ENTERPRISE_INFO).build();
            HttpGet tHttpGet = new HttpGet(tEocTargetUri);
            tHttpGet.addHeader(MdcConstant.TOKEN, pToken);
            tHttpGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pToken);
            tHttpGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tHttpGet.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String tResponse = dwHttpClient.execute(tHttpGet, String.class, new DWRequestOption(false));
            JsonNode tResponseNode = mapper.readTree(tResponse);
            JsonNode tDataNode;
            if (tResponseNode.get(MdcConstant.DATA) != null) {
                tDataNode = tResponseNode.get(MdcConstant.DATA);
            } else {
                throw new EocEnterpriseInfoRetrievedException(tResponseNode.get(MdcConstant.ERRORMESSAGE).asText(), getClass());
            }
            if (tDataNode.get(MdcConstant.SID) != null) {
                return tDataNode.get(MdcConstant.SID).asText();
            } else {
                return null;
            }
        } catch (EocEnterpriseInfoRetrievedException e) {
            throw e;
        } catch (Exception e) {
            throw new EocEnterpriseInfoRetrievedException(e.getMessage(), getClass());
        }
    }

    /**
     * 公司别列表查询(内含工厂)[分页]
     *
     * @param pToken pToken
     * @param pEocId pEocId
     * @return String
     * @throws Exception Exception
     */
    public String getCompanySid(String pToken, String pEocId) throws Exception {
        try {
            URI tEocTargetUri = DWURIBuilder.create(MdcApplicationParameter._EOC_HOST + InterfaceConstant.GET_COMPANY_INFO).addParameter("pageSize", "99999")
                    .build();
            HttpGet tHttpGet = new HttpGet(tEocTargetUri);
            tHttpGet.addHeader(MdcConstant.TOKEN, pToken);
            tHttpGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pToken);
            tHttpGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tHttpGet.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String tResponse = dwHttpClient.execute(tHttpGet, String.class, new DWRequestOption(false));
            JsonNode tResponseNode = mapper.readTree(tResponse);
            JsonNode tDataNode;
            if (tResponseNode.get(MdcConstant.DATA) != null) {
                tDataNode = tResponseNode.get(MdcConstant.DATA);
            } else {
                throw new EocCompanyInfoRetrievedException(tResponseNode.get(MdcConstant.ERRORMESSAGE).asText(), getClass());
            }
            if (tDataNode.get(MdcConstant.LIST) != null) {
                ArrayNode tCompanyListNode = (ArrayNode) tDataNode.get(MdcConstant.LIST);
                // 逐tCompanyListNode陣列中的每個jsonNode檢查，找出id與parent_eoc_id相同者，再取其sid
                for (JsonNode tCompanyNode : tCompanyListNode) {
                    if (tCompanyNode.get(MdcConstant.ID).asText().equals(pEocId)) {
                        return tCompanyNode.get(MdcConstant.SID).asText();
                    }
                }
            }
            return null;
        } catch (EocCompanyInfoRetrievedException e) {
            throw e;
        } catch (Exception e) {
            throw new EocCompanyInfoRetrievedException(e.getMessage(), getClass());
        }
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result;
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        Key key1 = new SecretKeySpec(Hex.decodeHex(secretKey.toCharArray()), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex(secretFile.toCharArray()));
        return new String(result);
    }
}
