package com.digiwin.metadatacache.services;

import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.exception.OmInfoRetrievedFailedException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class IntgInfoService {

    private final Log log = LogFactory.getLog(getClass());

    ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    /**
     * 調用地端產品取得om代碼清單
     */
    @SuppressWarnings("unchecked")
    public JsonNode getIntgInfo(String pEntId, String pTenantId, String pProdName, String pUid) throws Exception {
        try {
            log.info("調用地端產品取得om代碼清單，EntId：" + pEntId + " TenantId：" + pTenantId + " ProdName：" + pProdName + " Uid："
                    + pUid);
            // Host Acct
            String tAcct = "";
            switch (pProdName) {
                case "E10":
                    tAcct = "dcms";
                    break;
                case "WFGP":
                    tAcct = "DS";
                    break;
                case "TIPTOP":
                case "T100":
                    tAcct = "tiptop";
                    break;
            }
            //获取当前租户的版本
            String version = IamVerifyServiceUtil.getCurrentTenantVersion(pTenantId);
            Map<String, String> pEocIntgMappingMapCondition = new HashMap<>();
            //老版本处理
            if(MdcConstant.TENANT_VERSION_V1.equalsIgnoreCase(version)){

                pEocIntgMappingMapCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.ENTERPRISE_ID);
                pEocIntgMappingMapCondition.put(MdcConstant.TENANT_ID, pTenantId);
                pEocIntgMappingMapCondition.put(MdcConstant.UID, pUid);
            }else {
                pEocIntgMappingMapCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
                pEocIntgMappingMapCondition.put(MdcConstant.CLOUD_MAPPING_TYPE, MdcConstant.ENTERPRISE_ID);
                pEocIntgMappingMapCondition.put(MdcConstant.TENANT_ID, pTenantId);
                pEocIntgMappingMapCondition.put(MdcConstant.UID, pUid);
            }
            // datakey header
            List<EocIntgMapping> eocIntgMappings;
            eocIntgMappings = eocIntgMappingDao.fetch(pEocIntgMappingMapCondition);
            JsonObject tDatakeyObject = new JsonObject();
            // 該租戶如果有Ent，那把Ent的值放在datakey的header中
            if (pEntId != null && pEntId.length() != 0) {
                tDatakeyObject.addProperty("EntId", pEntId);
            } else if (!eocIntgMappings.isEmpty()) {
                tDatakeyObject.addProperty("EntId", eocIntgMappings.get(0).getEocId());
            }
            Map<String, Object> tBody = mapper.convertValue(
                    mapper.readTree("{ \"enterprise_no\": \"\", \"site_no\": \"\", \"call_id\": \"\" }"),
                    new TypeReference<Map<String, Object>>() {
                    });
            // 建立調用ESP物件
            String locale = DWServiceContext.getContext().getRequestHeader().getOrDefault("locale",System.getenv("message_language")).toString();
            DWEAIBuilder tDWEAIBuilder = new DWEAIBuilder(pProdName, "valid.organization.data.get", tBody)
                    .setDigiHostLang(DigiHost.lang.valueOf(locale)).setDigiHostAcct(tAcct).setDigiServiceUid(pUid)
                    .setDigiDatakey(tDatakeyObject.toString()).sync();
            // 租戶ID
            tDWEAIBuilder.getDigiService().setTenantId(pTenantId);
            Map<String, String> customHeader = new HashMap<>();
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN)) {
                customHeader.put(MdcConstant.TOKEN, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN).toString());
                tDWEAIBuilder.setCustomHeader(customHeader);
            }
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                customHeader.put(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
                tDWEAIBuilder.setCustomHeader(customHeader);
            }
            DWEAI tDWEAI = tDWEAIBuilder.build();
            Map<String, Object> tResponseMap = tDWEAI.execute();
            Map<String, Object> tResponseHeaders = (Map<String, Object>) tResponseMap.get("headers");
            // ESP系統類錯誤
            if (!"019".equals(tResponseHeaders.get("digi-code"))) {
                String tSB = tResponseHeaders.get("digi-message").toString() + " digi-reqid: " +
                        tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, getClass());
            }
            String tResponseBody = (String) tResponseMap.get("messageBody");
            // ESP返回body為空
            if (StringUtil.isEmptyOrSpace(tResponseBody)) {
                String tSB = pProdName + " response is empty." + " digi-reqid: " +
                        tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, getClass());
            }
            JsonNode tERPIntgReturnNode = mapper.readTree(tResponseBody);
            // ESP應用類錯誤
            if (!"000".equals(tResponseHeaders.get("digi-srvcode"))) {
                String tSB = pProdName + " response: " +
                        tERPIntgReturnNode.get(MdcConstant.STD_DATA).get(MdcConstant.EXECUTION).get(MdcConstant.DESCRIPTION).asText() +
                        " digi-reqid: " + tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, getClass());
            }
            JsonNode tIntgNode = tERPIntgReturnNode.get(MdcConstant.STD_DATA).get(MdcConstant.PARAMETER);
            log.info("調用地端產品取得om代碼清單成功，om清單：" + tIntgNode.toString());
            return tIntgNode;
        } catch (DWHttpFailedException e) {
            Map<String, Object> tFailedEntity = e.getEntity(Map.class);
            String tMsg = String.format("response: %s", tFailedEntity.get("message"));
            throw new OmInfoRetrievedFailedException(tMsg, getClass());
        }
    }
}
