package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWHttpResponseEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.bo.KgServiceProductConfigDto;
import com.digiwin.metadatacache.constant.InterfaceConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.KgFailException;
import lombok.extern.apachecommons.CommonsLog;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.net.URI;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/7/31 11:15
 */
@CommonsLog
@Service
public class MdcKgService {

    @Value("${iamApToken}")
    private String iamApToken;

    @Autowired
    private DWHttpClient dwHttpClient;

    public KgServiceProductConfigDto getServiceProductConfig(String tenantId, String serviceName) throws KgFailException {
        try {
            URI uri = DWURIBuilder.createServiceRouteDapAPI("thememap", InterfaceConstant.KG_GET_SERVICE_CONFIG_URL)
                    .setParameter("tenantId", tenantId).setParameter("serviceName", serviceName).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            httpGet.setHeader(MdcConstant.TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN));
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                httpGet.setHeader(MdcConstant.ROUTER_KEY, (String) DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY));
            }
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.SECURITY_TOKEN)) {
                httpGet.setHeader(MdcConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(MdcConstant.SECURITY_TOKEN));
            }
            DWHttpResponseEntity<KgServiceProductConfigDto> tDWHttpResponse = dwHttpClient.executeAndGetDWHttpResponseEntity(httpGet, KgServiceProductConfigDto.class, new DWRequestOption(false));
            return tDWHttpResponse.getResult();
        } catch (DWHttpFailedException e) {
            log.error(e.getEntity(String.class));
            throw new KgFailException(e, getClass());
        } catch (Exception e) {
            log.error(e);
            throw new KgFailException(e, getClass());
        }
    }
}
