package com.digiwin.metadatacache.services;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import com.digiwin.metadatacache.MdcApplicationParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.stereotype.Service;
import com.digiwin.metadatacache.util.StringUtil;

@Service
public class RedissonService {
	private final Log log = LogFactory.getLog(getClass());

	private RedissonClient client;

	private boolean isEnable = false;

	@PostConstruct
	public void init() {
		if (!StringUtil.isEmpty(MdcApplicationParameter._REDIS_HOST)) {
			final Config tConfig = new Config();
			SingleServerConfig tServerConfig = tConfig.useSingleServer();
			String tAddress = String.format("redis://%s:%s", MdcApplicationParameter._REDIS_HOST, MdcApplicationParameter._REDIS_PORT);
			tServerConfig.setAddress(tAddress);
			if (!StringUtil.isEmpty(MdcApplicationParameter._REDIS_PASSWORD)) {
				tServerConfig.setPassword(MdcApplicationParameter._REDIS_PASSWORD);
			}
			tServerConfig.setDatabase(MdcApplicationParameter._REDIS_DB);
			redissonCreate(tConfig);
			if (client == null) {
				final Timer tTimer = new Timer();
				tTimer.schedule(new TimerTask() {
					@Override
					public void run() {
						redissonCreate(tConfig);
					}
				}, TimeUnit.SECONDS.toMillis(10), TimeUnit.SECONDS.toMillis(10));
			}

		}
	}

	private void redissonCreate(Config pConfig) {
		try {
			client = Redisson.create(pConfig);
			log.info("Redis connect success");
			setEnable(true);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
	}

	public boolean lock(String pLockKey) throws InterruptedException {
		RLock tLock = client.getFairLock(pLockKey);
		return tLock.tryLock(120, 120, TimeUnit.SECONDS);
	}

	public void unLock(String pLockKey) {
		RLock tLock = client.getFairLock(pLockKey);
		tLock.unlock();
	}

	public boolean isEnable() {
		return isEnable;
	}

	public void setEnable(boolean isEnable) {
		this.isEnable = isEnable;
	}

	public RedissonClient getClient() {
		return client;
	}
}
