package com.digiwin.metadatacache.validator;

import java.util.Scanner;

import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.JsonFormatValidationException;
import com.digiwin.metadatacache.exception.JsonSyntaxValidationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;

public class JsonSchemaValidator {

	/**
	 * 入参验证
	 * @param pMessage pMessage
	 * @param pSchemaFileName pSchemaFileName
	 * @return ValidatorResult
	 * @throws Exception Exception
	 */
	public ValidatorResult validate(String pMessage, String pSchemaFileName) throws Exception {
		ValidatorResult tResult = new ValidatorResult();
		try {
			// 根據檔案名稱取得驗證綱要
			Scanner reader = new Scanner(getClass().getResourceAsStream("/schema/" + pSchemaFileName));
			StringBuilder builder = new StringBuilder();
			while (reader.hasNextLine()) {
				builder.append(reader.nextLine());
			}
			String jsonSchema = builder.toString();
			reader.close();
			JsonNode schemaNode = JsonLoader.fromString(jsonSchema);
			JsonNode jsonNode = JsonLoader.fromString(pMessage);
			ProcessingReport report = JsonSchemaFactory.byDefault().getValidator()
					.validateUnchecked(schemaNode, jsonNode);
			// 驗證成功
			if (report.isSuccess()) {
				tResult.setState(ValidateStateEnum.SUCCESS);
				// 回傳解析完的JSON_CONTENT
				tResult.setJsonContent(jsonNode);
				return tResult;
				// 驗證失敗
			} else {
				for (ProcessingMessage processMessage : report) {
					if (!LogLevel.WARNING.equals(processMessage.getLogLevel())) {
						tResult.setState(ValidateStateEnum.FORMAT_ERROR);
						// 取得發生錯誤的節點路徑
						JsonNode instanceNode = processMessage.asJson().get(MdcConstant.INSTANCE).get(MdcConstant.POINTER);
						tResult.setErrorNodePath(instanceNode.toString().replace("\"", ""));
						// 取得錯誤訊息
						tResult.setMessage(processMessage.getMessage().replace("\"", ""));

						throw new JsonFormatValidationException(
								tResult.getMessage() + MdcConstant.AT_STRING + tResult.getErrorNodePath(), this.getClass());
					}
				}
				throw new JsonFormatValidationException(this.getClass());
			}

		} catch (JsonParseException e) {
			throw new JsonSyntaxValidationException(e, this.getClass());
		}
	}
}
