/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.metadatacache.annotate.AppTokenVerify;
import com.digiwin.metadatacache.dao.ApiRelationDao;
import com.digiwin.metadatacache.dao.StateCodeDao;
import com.digiwin.metadatacache.enums.ErrorCodeEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.TokenNotRetrievedException;
import com.digiwin.metadatacache.model.ApiRelation;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.MdcCacheService;
import com.digiwin.metadatacache.util.DateUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.JsonSchemaValidator;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractApiService {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected static final StateCode SUCCESS_STATE = AbstractApiService.createSuccessStateCode();
    final JsonSchemaValidator jsonSchemaValidator = new JsonSchemaValidator();
    ObjectMapper mapper = new ObjectMapper();
    protected String jsonSchemaFileName;
    protected String requestMsg;
    protected String locale = "";
    @Autowired
    protected MdcCacheService cacheService;
    @Autowired
    private StateCodeDao stateCodeDao;
    @Autowired
    protected ApiRelationDao apiRelationDao;

    public Map<String, Object> execute(String pRequestMsg) throws Exception {
        StateCode tStateCode;
        StringBuilder tDescription = new StringBuilder();
        this.requestMsg = pRequestMsg;
        if (DWServiceContext.getContext().getRequestHeader().get("locale") != null) {
            this.locale = DWServiceContext.getContext().getRequestHeader().get("locale").toString();
        }
        try {
            for (Annotation annotation : this.getClass().getAnnotations()) {
                if (!AppTokenVerify.class.isAssignableFrom(annotation.annotationType())) continue;
                Object appToken = DWServiceContext.getContext().getRequestHeader().get("digi-middleware-auth-app");
                this.log.info((Object)("appToken: " + appToken));
                if (null == appToken) {
                    throw new TokenNotRetrievedException("app_token\u9274\u6743\u5931\u8d25", this.getClass());
                }
                DecodedJWT jwt = JWT.decode((String)appToken.toString());
                String appId = jwt.getClaim("id").asString();
                if (!StringUtils.isBlank((CharSequence)appId)) continue;
                throw new TokenNotRetrievedException("app_token\u9274\u6743\u5931\u8d25", this.getClass());
            }
            ValidatorResult tValidatorResult = this.validate(pRequestMsg);
            return this.processData(tValidatorResult);
        }
        catch (DWHttpFailedException e) {
            String exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity + ";requestMsg = " + pRequestMsg), (Throwable)e);
            throw new Exception(exceptionEntity);
        }
        catch (BaseException e) {
            this.log.error((Object)(e.getMessage() + ";requestMsg = " + pRequestMsg), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescription.append(this.getDescriptionByLocale(tStateCode, this.locale));
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                tDescription.append("\uff1a").append(e.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error((Object)(e.getMessage() + ";requestMsg = " + pRequestMsg), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescription.append(this.getDescriptionByLocale(tStateCode, this.locale));
        }
        return this.converJsonNodeToMap((JsonNode)this.createResponseJsonNode(tStateCode.getCode(), tDescription.toString()));
    }

    protected ValidatorResult validate(String pMsg) throws Exception {
        return this.jsonSchemaValidator.validate(pMsg, this.jsonSchemaFileName);
    }

    protected Map<String, Map<String, Map<String, List<EocIntgMapping>>>> groupEocMappingByTenantAndProdNameAndUid(List<EocIntgMapping> pEocIntgMappings, String pTenantId) {
        HashMap<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = new HashMap<String, Map<String, Map<String, List<EocIntgMapping>>>>();
        for (EocIntgMapping mapping : pEocIntgMappings) {
            ArrayList<EocIntgMapping> tEocIntgMappingList;
            HashMap<String, ArrayList<EocIntgMapping>> tProductUidMap;
            HashMap tProductNameMap = (HashMap)tTotalMap.get(pTenantId);
            if (MapUtils.isEmpty((Map)tProductNameMap)) {
                tProductNameMap = new HashMap();
                tTotalMap.put(pTenantId, tProductNameMap);
            }
            if (MapUtils.isEmpty((Map)(tProductUidMap = (HashMap<String, ArrayList<EocIntgMapping>>)tProductNameMap.get(mapping.getProducName())))) {
                tProductUidMap = new HashMap<String, ArrayList<EocIntgMapping>>();
                tProductNameMap.put(mapping.getProducName(), tProductUidMap);
            }
            if (CollectionUtils.isEmpty((Collection)(tEocIntgMappingList = (ArrayList<EocIntgMapping>)tProductUidMap.get(mapping.getProductUid())))) {
                tEocIntgMappingList = new ArrayList<EocIntgMapping>();
                tProductUidMap.put(mapping.getProductUid(), tEocIntgMappingList);
            }
            tEocIntgMappingList.add(mapping);
        }
        return tTotalMap;
    }

    protected Map<String, Object> converJsonNodeToMap(JsonNode pJsonNode) {
        return (Map)this.mapper.convertValue((Object)pJsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected Map<String, Object> converJsonStringToMap(String pJsonString) throws IOException {
        return this.converJsonNodeToMap(this.mapper.readTree(pJsonString));
    }

    protected StateCode getStateCode(String pStateCode) {
        return this.stateCodeDao.getStateCodeByCode(pStateCode);
    }

    protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pDataNode) {
        ObjectNode tResponseJsonNode = this.mapper.createObjectNode();
        ObjectNode tExecutionNode = this.mapper.createObjectNode();
        tResponseJsonNode.set("execution", (JsonNode)tExecutionNode);
        tExecutionNode.put("code", pCode);
        if (!StringUtil.isEmptyOrSpace(pDescription)) {
            tExecutionNode.put("description", pDescription);
        }
        if (pDataNode != null) {
            tResponseJsonNode.set("data", pDataNode);
        }
        this.checkErrorCode(pCode, pDescription, tResponseJsonNode);
        return tResponseJsonNode;
    }

    protected Map<String, Object> createResponseMap(String pCode, String pDescription, Map<String, Object> pDataNode) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, String> tExecutionNode = new HashMap<String, String>();
        response.put("execution", tExecutionNode);
        tExecutionNode.put("code", pCode);
        if (!StringUtil.isEmptyOrSpace(pDescription)) {
            tExecutionNode.put("description", pDescription);
        }
        if (pDataNode != null) {
            response.put("data", pDataNode);
        }
        this.checkErrorCode(pCode, pDescription, response);
        return response;
    }

    private void checkErrorCode(String code, String description, ObjectNode tResponseJsonNode) {
        ErrorCodeEnum errorCode = ErrorCodeEnum.ERRORCODEENUM_CODE_MAP.get(code);
        if (null != errorCode) {
            tResponseJsonNode.put("errorCode", errorCode.getErrorCode());
            tResponseJsonNode.put("errorMessage", description);
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            chainInfo = StringUtils.substringAfter((String)chainInfo, (String)"trace info: me: ");
            ObjectNode chainInfoNode = this.mapper.createObjectNode();
            chainInfoNode.put("chainInfo", chainInfo);
            tResponseJsonNode.set("errorInstructors", (JsonNode)chainInfoNode);
        }
    }

    private void checkErrorCode(String code, String description, Map<String, Object> tResponseJsonNode) {
        ErrorCodeEnum errorCode = ErrorCodeEnum.ERRORCODEENUM_CODE_MAP.get(code);
        if (null != errorCode) {
            tResponseJsonNode.put("errorCode", errorCode.getErrorCode());
            tResponseJsonNode.put("errorMessage", description);
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            chainInfo = StringUtils.substringAfter((String)chainInfo, (String)"trace info: me: ");
            ObjectNode chainInfoNode = this.mapper.createObjectNode();
            chainInfoNode.put("chainInfo", chainInfo);
            tResponseJsonNode.put("errorInstructors", chainInfoNode);
        }
    }

    private static StateCode createSuccessStateCode() {
        StateCode stateCode = new StateCode();
        stateCode.setCode(ValidateStateEnum.SUCCESS.getCode());
        stateCode.setDescription("\u57f7\u884c\u6210\u529f");
        stateCode.setDescriptionEnUs("\u6267\u884c\u6210\u529f");
        stateCode.setDescriptionZhCn("\u6267\u884c\u6210\u529f");
        return stateCode;
    }

    private ObjectNode createResponseJsonNode(String pCode, String pDescription) {
        return this.createResponseJsonNode(pCode, pDescription, null);
    }

    protected abstract Map<String, Object> processData(ValidatorResult var1) throws BaseException, Exception;

    protected String getDescriptionByLocale(StateCode pStateCode, String pLocale) {
        String tDescriptionByLocale;
        switch (pLocale) {
            case "zh_TW": {
                tDescriptionByLocale = pStateCode.getDescription();
                break;
            }
            case "en_US": {
                tDescriptionByLocale = pStateCode.getDescriptionEnUs();
                break;
            }
            default: {
                tDescriptionByLocale = pStateCode.getDescriptionZhCn();
            }
        }
        return tDescriptionByLocale;
    }

    protected String sendMqMessage(Map<String, Object> pDataMap) {
        ObjectNode tApiMetadataNode = this.mapper.createObjectNode();
        tApiMetadataNode.put("api_name", pDataMap.get("api_name").toString());
        if (pDataMap.get("tenant_id") != null) {
            tApiMetadataNode.put("tenant_id", pDataMap.get("tenant_id").toString());
            if (pDataMap.get("package_name") != null) {
                tApiMetadataNode.put("package_name", pDataMap.get("package_name").toString());
            }
        }
        if (null != pDataMap.get("api_extend")) {
            tApiMetadataNode.put("api_extend", pDataMap.get("api_extend").toString());
        }
        String tDate = DateUtil.formatToDate(new Date());
        tApiMetadataNode.put("timestamp", tDate);
        tApiMetadataNode.put("action", "add");
        tApiMetadataNode.put("type", pDataMap.get("type").toString());
        tApiMetadataNode.put("category", pDataMap.get("category").toString());
        ObjectNode tDescriptionNode = this.mapper.createObjectNode();
        tDescriptionNode.put("zh_TW", pDataMap.get("description_zh_tw").toString());
        tDescriptionNode.put("zh_CN", pDataMap.get("description_zh_cn").toString());
        tDescriptionNode.put("en", pDataMap.get("description_en").toString());
        tApiMetadataNode.set("description", (JsonNode)tDescriptionNode);
        ObjectNode tRemarkNode = this.mapper.createObjectNode();
        tRemarkNode.put("zh_TW", pDataMap.get("remark_zh_tw").toString());
        tRemarkNode.put("zh_CN", pDataMap.get("remark_zh_cn").toString());
        tRemarkNode.put("en", pDataMap.get("remark_en").toString());
        tApiMetadataNode.set("remark", (JsonNode)tRemarkNode);
        ObjectNode tApiVersionInfo = (ObjectNode)pDataMap.get("api_version_info");
        ArrayList keys = new ArrayList();
        Iterator iterator = tApiVersionInfo.fieldNames();
        iterator.forEachRemaining(keys::add);
        tApiMetadataNode.put("api_version", (String)keys.get(0));
        tApiMetadataNode.put("url", DWApplicationConfigUtils.getProperty((String)"eaiUrl") + "/CROSS/RESTful");
        tApiMetadataNode.set("data_metadata", tApiVersionInfo.get((String)keys.get(0)));
        tApiMetadataNode.put("idempotency", pDataMap.get("idempotency").toString());
        return tApiMetadataNode.toString();
    }

    protected String getParentName(String apiName, String tenantId) {
        String parentName = null;
        List<ApiRelation> apiRelations = this.apiRelationDao.getRelationBySub(apiName, tenantId);
        if (CollectionUtils.isNotEmpty(apiRelations)) {
            List apiRelationList = apiRelations.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSubTenantId()) && tenantId.equals(x.getSubTenantId())).collect(Collectors.toList());
            parentName = CollectionUtils.isNotEmpty(apiRelationList) ? ((ApiRelation)apiRelationList.get(0)).getParentApiName() : apiRelations.get(0).getParentApiName();
        }
        return parentName;
    }

    protected ApiVersion getLastedVersion(List<ApiVersion> apiVersions) {
        String tMaxVer = "0.0";
        ApiVersion tMaxApiVer = null;
        for (ApiVersion tApiVersion : apiVersions) {
            String[] versionSplit = tApiVersion.getVersion().split("\\.");
            String[] maxVersionSplit = tMaxVer.split("\\.");
            String versionInteger = versionSplit[0];
            String versionDecimal = versionSplit[1];
            String maxVersionInteger = maxVersionSplit[0];
            String maxVersionDecimal = maxVersionSplit[1];
            if (Integer.parseInt(versionInteger) > Integer.parseInt(maxVersionInteger)) {
                tMaxVer = tApiVersion.getVersion();
                tMaxApiVer = tApiVersion;
                continue;
            }
            if (!Integer.valueOf(versionInteger).equals(Integer.valueOf(maxVersionInteger)) || Integer.parseInt(versionDecimal) <= Integer.parseInt(maxVersionDecimal)) continue;
            tMaxVer = tApiVersion.getVersion();
            tMaxApiVer = tApiVersion;
        }
        return tMaxApiVer;
    }
}

