/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiInfoGet
extends AbstractApiService {
    private final SimpleDateFormat gDateFormat4Gwt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    @Autowired
    private ApiVersionDao apiVersionDao;

    public ApiInfoGet() {
        this.jsonSchemaFileName = "api_info_get.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tBuildTime = tRequestJsonNode.get("build_time").asText();
        String tProvider = null;
        if (tRequestJsonNode.get("provider") != null) {
            tProvider = tRequestJsonNode.get("provider").asText();
        }
        Calendar tCalender = null;
        try {
            Date tDate = this.gDateFormat4Gwt.parse(tBuildTime);
            tCalender = Calendar.getInstance();
            tCalender.setTime(tDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List<ApiVersion> tApiVersionList = this.apiVersionDao.getApiInfo(tCalender, tProvider);
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tVersionAryNode = this.mapper.createArrayNode();
        if (tApiVersionList != null) {
            for (ApiVersion tApiVersion : tApiVersionList) {
                boolean tBoolean = false;
                if (tProvider != null) {
                    String[] tProviderArr;
                    String tProviders = tApiVersion.getApi().getProvider().trim();
                    for (String s : tProviderArr = tProviders.split(",")) {
                        if (!s.trim().equals(tProvider)) continue;
                        tBoolean = true;
                        break;
                    }
                } else {
                    tBoolean = true;
                }
                if (!tBoolean) continue;
                ObjectNode tAppVerNode = this.mapper.createObjectNode();
                tAppVerNode.put("api_name", tApiVersion.getApi().getName().trim());
                tAppVerNode.put("api_version", tApiVersion.getVersion().trim());
                tAppVerNode.put("provider", tApiVersion.getApi().getProvider().trim());
                ObjectNode tDescriptionNode = this.mapper.createObjectNode();
                tDescriptionNode.put("zh_TW", tApiVersion.getApi().getDescriptionZhTw().trim());
                tDescriptionNode.put("zh_CN", tApiVersion.getApi().getDescriptionZhCn().trim());
                tDescriptionNode.put("en", tApiVersion.getApi().getDescriptionEn().trim());
                tAppVerNode.set("description", (JsonNode)tDescriptionNode);
                ObjectNode tRemarkNode = this.mapper.createObjectNode();
                tRemarkNode.put("zh_TW", tApiVersion.getApi().getRemarkZhTw().trim());
                tRemarkNode.put("zh_CN", tApiVersion.getApi().getRemarkZhCn().trim());
                tRemarkNode.put("en", tApiVersion.getApi().getRemarkEn().trim());
                tAppVerNode.set("remark", (JsonNode)tRemarkNode);
                tAppVerNode.put("approved_status", tApiVersion.getApprovedStatus().toString().trim());
                tVersionAryNode.add((JsonNode)tAppVerNode);
            }
        }
        tDataNode.set("api_ver", (JsonNode)tVersionAryNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

