/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanCacheService
extends AbstractApiService {
    @Autowired
    private DWRedisService redisService;
    @Autowired
    private LoadCacheService loadCacheService;

    public CleanCacheService() {
        this.jsonSchemaFileName = "clean_cache_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        String tType;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        switch (tType = tRequestJsonNode.get("type").asText()) {
            case "all": {
                CacheMapTypeEnum[] tCacheEnums = CacheMapTypeEnum.values();
                String[] tCacheKeys = new String[tCacheEnums.length];
                for (int i = 0; i < tCacheEnums.length; ++i) {
                    tCacheKeys[i] = tCacheEnums[i].getCode();
                }
                this.redisService.remove(tCacheKeys);
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode() + "*");
                this.cacheService.removeByPattern(CacheMapTypeEnum.api_version_list.getCode() + "*");
                break;
            }
            case "dispatch": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + "*");
                break;
            }
            case "organizationList": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + "*");
                break;
            }
            case "omTenant": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                break;
            }
            case "globalParam": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.global_param_cachemap.getCode() + "*");
                break;
            }
            case "apiMetadata": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.api_metadata_cachemap.getCode() + "*");
                break;
            }
            case "tenantProductMappingList": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode() + "*");
                break;
            }
            case "apiVersionList": {
                this.cacheService.removeByPattern(CacheMapTypeEnum.api_version_list.getCode() + "*");
                break;
            }
            case "apiBaseInfo": {
                this.loadCacheService.removeAllData();
                break;
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

