/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudRegionMappingGetService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public CloudRegionMappingGetService() {
        this.jsonSchemaFileName = "cloud_region_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        boolean tNameInclude = false;
        if (tRequestJsonNode.get("name_include") != null) {
            tNameInclude = tRequestJsonNode.get("name_include").asBoolean();
        }
        return this.processTenantOperationListGetV2(tTenantId, tNameInclude);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> processTenantOperationListGetV2(String pTenantId, Boolean pNameInclude) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("eoc_level", "cloud_mapping_id");
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        Map<Object, Object> tEocNode = new HashMap();
        if (pNameInclude.booleanValue() && !tMappings.isEmpty()) {
            try {
                tEocNode = EocInfoServiceUtil.getEocInfoV2MapByTenantId(pTenantId);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        ObjectNode tEnterpriseObjectNode = this.mapper.createObjectNode();
        ArrayList<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<EocIntgMapping>();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (!eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.enterprise_id.toString())) continue;
            tEnterpriseIdMappings.add(eocIntgMapping);
        }
        if (!tEnterpriseIdMappings.isEmpty()) {
            tEnterpriseObjectNode.put("eoc_enterprise_id", ((EocIntgMapping)tEnterpriseIdMappings.get(0)).getEocId());
            tEnterpriseObjectNode.put("om_enterprise_id", ((EocIntgMapping)tEnterpriseIdMappings.get(0)).getIntgId());
        } else {
            tEnterpriseObjectNode.put("eoc_enterprise_id", "");
            tEnterpriseObjectNode.put("om_enterprise_id", "");
        }
        HashMap tMappingsGroupByProductName = new HashMap();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (tMappingsGroupByProductName.get(eocIntgMapping.getProducName()) == null) {
                ArrayList<EocIntgMapping> tProductNameMappingList = new ArrayList<EocIntgMapping>();
                tProductNameMappingList.add(eocIntgMapping);
                tMappingsGroupByProductName.put(eocIntgMapping.getProducName(), tProductNameMappingList);
                continue;
            }
            ((List)tMappingsGroupByProductName.get(eocIntgMapping.getProducName())).add(eocIntgMapping);
        }
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (String tProductName : tMappingsGroupByProductName.keySet()) {
            JsonNode tIntgInfoNode = null;
            try {
                if (pNameInclude.booleanValue()) {
                    tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, tProductName, ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            ArrayList<EocIntgMapping> tCompanyIdMappings = new ArrayList<EocIntgMapping>();
            ArrayList<EocIntgMapping> tSiteIdMappings = new ArrayList<EocIntgMapping>();
            ArrayList<EocIntgMapping> tRegionIdMappings = new ArrayList<EocIntgMapping>();
            for (EocIntgMapping mapping2 : (List)tMappingsGroupByProductName.get(tProductName)) {
                if (mapping2.getCloudMappingType().equals(EocLevelEnum.company_id.toString())) {
                    tCompanyIdMappings.add(mapping2);
                    continue;
                }
                if (mapping2.getCloudMappingType().equals(EocLevelEnum.site_id.toString())) {
                    tSiteIdMappings.add(mapping2);
                    continue;
                }
                if (!mapping2.getCloudMappingType().equals(EocLevelEnum.region_id.toString())) continue;
                tRegionIdMappings.add(mapping2);
            }
            ObjectNode tProdEocMappingObjectNode = this.mapper.createObjectNode();
            if (pNameInclude.booleanValue()) {
                void var19_28;
                HashMap<String, String> tPrdCondition = new HashMap<String, String>();
                tPrdCondition.put("name", tProductName);
                tPrdCondition.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                List<Product> tProducts = this.productDao.fetch(tPrdCondition);
                String string = "";
                String tEocSettingRegion = "";
                if (tProducts != null && tProducts.size() != 0 && ((Product)tProducts.get(0)).getEocSetting() != null) {
                    String string2 = ((Product)tProducts.get(0)).getEocSetting();
                    tEocSettingRegion = ((Product)tProducts.get(0)).getEocSettingRegion();
                }
                tProdEocMappingObjectNode.put("eoc_setting", (String)var19_28);
                tProdEocMappingObjectNode.put("eoc_setting_region", tEocSettingRegion);
            }
            tProdEocMappingObjectNode.put("prod_name", tProductName);
            tProdEocMappingObjectNode.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
            ArrayNode tOrgTypeCompanyArrayNode = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_company", (JsonNode)tOrgTypeCompanyArrayNode);
            for (EocIntgMapping eocIntgMapping : tCompanyIdMappings) {
                ObjectNode tCompanyLevelMappingNode = this.mapper.createObjectNode();
                tCompanyLevelMappingNode.put("eoc_company_id", eocIntgMapping.getEocId());
                if (pNameInclude.booleanValue()) {
                    if (tEocNode.get(eocIntgMapping.getEocId()) != null) {
                        tCompanyLevelMappingNode.put("eoc_company_name", (String)tEocNode.get(eocIntgMapping.getEocId()));
                    }
                    if (tIntgInfoNode != null) {
                        ArrayNode tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        for (Object tIntgCompanyObject : tIntgCompanyAryNode) {
                            if (!eocIntgMapping.getIntgId().equals(tIntgCompanyObject.get("company_no").asText())) continue;
                            tCompanyLevelMappingNode.set("om_company_name", tIntgCompanyObject.get("company_name"));
                        }
                    }
                }
                tCompanyLevelMappingNode.put("om_company_id", eocIntgMapping.getIntgId());
                if (eocIntgMapping.getDatakey() != null && eocIntgMapping.getDatakey().length() != 0) {
                    tCompanyLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
                }
                tOrgTypeCompanyArrayNode.add((JsonNode)tCompanyLevelMappingNode);
            }
            ArrayNode tOrgTypeSiteArrayNode = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_site", (JsonNode)tOrgTypeSiteArrayNode);
            for (EocIntgMapping mapping4 : tSiteIdMappings) {
                ObjectNode tSiteLevelMappingNode = this.mapper.createObjectNode();
                tSiteLevelMappingNode.put("eoc_site_id", mapping4.getEocId());
                if (pNameInclude.booleanValue()) {
                    if (tEocNode.get(mapping4.getEocId()) != null) {
                        tSiteLevelMappingNode.put("eoc_site_name", (String)tEocNode.get(mapping4.getEocId()));
                    }
                    if (tIntgInfoNode != null) {
                        Object tIntgCompanyObject;
                        ArrayNode tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        tIntgCompanyObject = tIntgCompanyAryNode.iterator();
                        while (tIntgCompanyObject.hasNext()) {
                            JsonNode tIntgCompanyObject2 = (JsonNode)tIntgCompanyObject.next();
                            if (tIntgCompanyObject2.get("org_type_site") == null) continue;
                            for (JsonNode tIntgSiteObject : tIntgCompanyObject2.get("org_type_site")) {
                                if (!mapping4.getIntgId().equals(tIntgSiteObject.get("site_no").asText())) continue;
                                tSiteLevelMappingNode.set("om_site_name", tIntgSiteObject.get("site_name"));
                            }
                        }
                    }
                }
                tSiteLevelMappingNode.put("om_site_id", mapping4.getIntgId());
                if (mapping4.getDatakey() != null && mapping4.getDatakey().length() != 0) {
                    tSiteLevelMappingNode.put("datakey", mapping4.getDatakey());
                }
                tOrgTypeSiteArrayNode.add((JsonNode)tSiteLevelMappingNode);
            }
            ArrayNode arrayNode2 = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_region", (JsonNode)arrayNode2);
            for (EocIntgMapping mapping5 : tRegionIdMappings) {
                ObjectNode tRegionLevelMappingNode = this.mapper.createObjectNode();
                tRegionLevelMappingNode.put("eoc_region_id", mapping5.getEocId());
                if (pNameInclude.booleanValue()) {
                    ArrayNode tIntgRegionAryNode;
                    if (tEocNode.get(mapping5.getEocId()) != null) {
                        tRegionLevelMappingNode.put("eoc_region_name", (String)tEocNode.get(mapping5.getEocId()));
                    }
                    if (tIntgInfoNode != null && (tIntgRegionAryNode = (ArrayNode)tIntgInfoNode.get("org_type_region")) != null) {
                        for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
                            if (!mapping5.getIntgId().equals(tIntgRegionObject.get("region_no").asText())) continue;
                            tRegionLevelMappingNode.set("om_region_name", tIntgRegionObject.get("region_name"));
                        }
                    }
                }
                tRegionLevelMappingNode.put("om_region_id", mapping5.getIntgId());
                if (mapping5.getDatakey() != null && mapping5.getDatakey().length() != 0) {
                    tRegionLevelMappingNode.put("datakey", mapping5.getDatakey());
                }
                arrayNode2.add((JsonNode)tRegionLevelMappingNode);
            }
            arrayNode.add((JsonNode)tProdEocMappingObjectNode);
        }
        StateCode stateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(stateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(stateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_enterprise", (JsonNode)tEnterpriseObjectNode);
        tResponseJsonNode.set("prod_eoc_mapping", (JsonNode)arrayNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

