/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmTenantIdGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;
    @Autowired
    private ProductDao productDao;

    public OmTenantIdGetService() {
        this.jsonSchemaFileName = "om_tenantid_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tEaiUid = tRequestJsonNode.get("eai_uid").asText();
        String tProdUid = tRequestJsonNode.get("prod_uid").asText();
        JsonNode tOmMapNode = tRequestJsonNode.get("om_map");
        String tOmCompanyId = null;
        String tOmSiteId = null;
        String tReturnedTenantId = "";
        if (tOmMapNode.get("om_company_id") != null && tOmMapNode.get("om_company_id").asText().length() != 0) {
            tOmCompanyId = tOmMapNode.get("om_company_id").asText();
        }
        if (tOmMapNode.get("om_site_id") != null && tOmMapNode.get("om_site_id").asText().length() != 0) {
            tOmSiteId = tOmMapNode.get("om_site_id").asText();
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("eai_uid", tEaiUid);
        condition.put("uid", tProdUid);
        List<Product> tProducts = this.productDao.fetch(condition);
        if (CollectionUtils.isNotEmpty(tProducts)) {
            Product product = tProducts.get(0);
            String tenantId = product.getTenantId();
            String version = IamVerifyServiceUtil.getCurrentTenantVersion(tenantId);
            if ("v1".equalsIgnoreCase(version)) {
                List<EocIntgMapping> tCompanyEocIntgMappings;
                String tKey;
                String tCacheMapKey;
                block17: {
                    tCacheMapKey = CacheMapTypeEnum.om_tenant_cachemap.getCode();
                    tKey = null;
                    if (tOmCompanyId != null) {
                        String tDataFromCache;
                        StringBuilder tSB = new StringBuilder();
                        tSB.append(tEaiUid).append(":").append(tProdUid).append(":").append(tOmCompanyId);
                        if (tOmSiteId != null) {
                            tSB.append(":").append(tOmSiteId);
                        }
                        if (null != (tDataFromCache = this.cacheService.getCacheMapValue(tCacheMapKey, tKey = tSB.toString()))) {
                            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tCacheMapKey + "// " + tKey));
                            return this.converJsonStringToMap(tDataFromCache);
                        }
                    }
                    tCompanyEocIntgMappings = null;
                    HashMap<String, String> tCompanyEocIntgMappingCondition = new HashMap<String, String>();
                    HashMap<String, String> tSiteEocIntgMappingCondition = new HashMap<String, String>();
                    if (tOmCompanyId != null) {
                        tCompanyEocIntgMappingCondition.put("product_uid", tProdUid);
                        tCompanyEocIntgMappingCondition.put("intg_id", tOmCompanyId);
                        tCompanyEocIntgMappingCondition.put("eoc_level", "company_id");
                        tCompanyEocIntgMappings = this.eocIntgMappingDao.fetch(tCompanyEocIntgMappingCondition);
                    }
                    if (CollectionUtils.isNotEmpty(tCompanyEocIntgMappings)) {
                        if (tOmSiteId != null) {
                            tSiteEocIntgMappingCondition.put("product_uid", tProdUid);
                            tSiteEocIntgMappingCondition.put("intg_id", tOmSiteId);
                            tSiteEocIntgMappingCondition.put("eoc_level", "site_id");
                            List<EocIntgMapping> tSiteEocIntgMappings = this.eocIntgMappingDao.fetch(tSiteEocIntgMappingCondition);
                            if (CollectionUtils.isNotEmpty(tSiteEocIntgMappings)) {
                                for (EocIntgMapping tSiteEocIntgMapping : tSiteEocIntgMappings) {
                                    for (EocIntgMapping tCompanyEocIntgMapping : tCompanyEocIntgMappings) {
                                        if (tSiteEocIntgMapping.getEocIntgMapping() == null || !tSiteEocIntgMapping.getEocIntgMapping().getId().equals(tCompanyEocIntgMapping.getId())) continue;
                                        HashMap<String, String> tEaiTenantMappingCondition = new HashMap<String, String>();
                                        tEaiTenantMappingCondition.put("eai_uid", tEaiUid);
                                        tEaiTenantMappingCondition.put("tenant_id", tCompanyEocIntgMappings.get(0).getTenantId());
                                        List<EaiTenantMapping> tEaiTenantMappings = this.eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
                                        if (tEaiTenantMappings == null || tEaiTenantMappings.isEmpty()) continue;
                                        tReturnedTenantId = tSiteEocIntgMapping.getTenantId();
                                        break block17;
                                    }
                                }
                            }
                        } else {
                            for (EocIntgMapping tEocIntgMapping : tCompanyEocIntgMappings) {
                                HashMap<String, String> tEaiTenantMappingCondition = new HashMap<String, String>();
                                tEaiTenantMappingCondition.put("eai_uid", tEaiUid);
                                tEaiTenantMappingCondition.put("tenant", tEocIntgMapping.getTenantId());
                                List<EaiTenantMapping> tEaiTenantMappings = this.eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
                                if (!CollectionUtils.isNotEmpty(tEaiTenantMappings)) continue;
                                tReturnedTenantId = tEocIntgMapping.getTenantId();
                                break;
                            }
                        }
                    }
                }
                StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
                String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
                ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
                tResponseJsonNode.put("tenant_id", tReturnedTenantId);
                if (tStateCode.getCode().equals("000") && tKey != null && CollectionUtils.isNotEmpty(tCompanyEocIntgMappings)) {
                    this.cacheService.setCacheMapValue(tCacheMapKey, tKey, tResponseJsonNode.toString());
                }
                return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
            }
            HashMap<String, String> tEocIntgMappingCondition = new HashMap<String, String>();
            tEocIntgMappingCondition.put("product_uid", tProdUid);
            tEocIntgMappingCondition.put("tenant_id", tenantId);
            tEocIntgMappingCondition.put("eoc_level", "cloud_mapping_id");
            List<EocIntgMapping> list = this.eocIntgMappingDao.fetch(tEocIntgMappingCondition);
            List intgIds = list.stream().map(EocIntgMapping::getIntgId).collect(Collectors.toList());
            if (intgIds.contains(tOmCompanyId) || intgIds.contains(tOmSiteId)) {
                tReturnedTenantId = tenantId;
            }
            StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
            String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
            ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
            tResponseJsonNode.put("tenant_id", tReturnedTenantId);
            return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

