/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.apiservice.ApiRelationDeleteService;
import com.digiwin.metadatacache.apiservice.AssetRegisterService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiMetadataDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LoadCacheService;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.util.DateUtil;
import com.digiwin.metadatacache.util.MQUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StdApiMetadataDeleteService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    private ApiMetadataDao apiMetadataDao;
    @Autowired
    private ApiRelationDeleteService apiRelationDeleteService;
    @Autowired
    protected LoadCacheService loadCacheService;
    @Autowired
    private LocalCacheService localCacheService;
    @Autowired
    private AssetRegisterService assetRegisterService;

    public StdApiMetadataDeleteService() {
        this.jsonSchemaFileName = "standard_api_delete_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tUserId = (String)DWServiceContext.getContext().getRequestHeader().get("userId");
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("api_info");
        boolean sendMqJudge = false;
        if (tRequestJsonNode.get("sendMqJudge") != null) {
            sendMqJudge = tRequestJsonNode.get("sendMqJudge").asBoolean(false);
        }
        if (tApiArrayNode.isArray()) {
            for (JsonNode tApi : tApiArrayNode) {
                String tApiName = tApi.get("name").asText();
                String tApiVersion = tApi.get("version").asText();
                String tTenantId = null;
                if (tApi.get("tenant_id") != null && tApi.get("tenant_id").asText().length() != 0) {
                    tTenantId = tApi.get("tenant_id").asText();
                }
                this.apiDao.removeByNameAndVersionTenantId(tApiName, tApiVersion, tTenantId);
                this.cacheService.remove(CacheMapTypeEnum.api_version_list.getCode() + ":" + tApiName);
                this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u6e05\u9664\u670d\u52d9\u7248\u672c\u865f)\uff1akey = " + CacheMapTypeEnum.api_version_list.getCode() + ":" + tApiName));
                this.loadCacheService.removeData(CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + tApiName);
                this.localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, tApiName);
                this.log.info((Object)("\u5220\u9664\u672c\u5730\u7f13\u5b58: " + CacheMapTypeEnum.api_base_info_cachemap.getCode() + ":" + tApiName));
                ObjectNode tApiMetadataNode = this.mapper.createObjectNode();
                tApiMetadataNode.put("api_name", tApiName);
                tApiMetadataNode.put("api_version", tApiVersion);
                if (tTenantId != null) {
                    tApiMetadataNode.put("tenant_id", tTenantId);
                }
                String tDate = DateUtil.formatToDate(new Date());
                tApiMetadataNode.put("timestamp", tDate);
                tApiMetadataNode.put("action", "delete");
                this.log.info((Object)("\u540c\u6b65\u5220\u9664\u4fe1\u606f\u81f3MQ\u5f00\u59cb_API\u540d\u79f0:" + tApiName + ",API\u7248\u672c:" + tApiVersion + ",API\u79df\u6237:" + tTenantId));
                MQUtil.sendApiMetadata(tApiMetadataNode.toString());
                this.log.info((Object)("\u540c\u6b65\u5220\u9664\u4fe1\u606f\u81f3MQ\u6210\u529f_API\u540d\u79f0:" + tApiName + ",API\u7248\u672c:" + tApiVersion + ",API\u79df\u6237:" + tTenantId));
                if (!sendMqJudge) continue;
                HashMap<String, Object> tDataMap = new HashMap<String, Object>();
                List<ApiVersion> apiVersionList = this.apiVersionDao.getByApiNameAndTenantId(tApiName, tTenantId);
                if (CollectionUtils.isNotEmpty(apiVersionList)) {
                    ApiVersion apiVersion = this.getLastedVersion(apiVersionList);
                    tDataMap.put("api_name", apiVersion.getApi().getName());
                    tDataMap.put("type", apiVersion.getApi().getInvokedType());
                    tDataMap.put("category", apiVersion.getApi().getCategory());
                    tDataMap.put("provider", apiVersion.getApi().getProvider());
                    if (StringUtils.isNotBlank((CharSequence)apiVersion.getApi().getTenantId())) {
                        tDataMap.put("tenant_id", apiVersion.getApi().getTenantId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)apiVersion.getApi().getApiExtend())) {
                        tDataMap.put("api_extend", apiVersion.getApi().getApiExtend());
                    }
                    tDataMap.put("package_name", apiVersion.getApi().getPackageName());
                    tDataMap.put("approved_status", apiVersion.getApprovedStatus());
                    tDataMap.put("idempotency", apiVersion.isIdempotency());
                    tDataMap.put("description_zh_tw", apiVersion.getApi().getDescriptionZhTw());
                    tDataMap.put("description_zh_cn", apiVersion.getApi().getDescriptionZhCn());
                    tDataMap.put("description_en", apiVersion.getApi().getDescriptionEn());
                    tDataMap.put("remark_zh_tw", apiVersion.getApi().getRemarkZhTw());
                    tDataMap.put("remark_zh_cn", apiVersion.getApi().getRemarkZhCn());
                    tDataMap.put("remark_en", apiVersion.getApi().getRemarkEn());
                    List<ApiMetadata> apiMetadataList = this.apiMetadataDao.getByApiVersionId(apiVersion.getId());
                    if (!CollectionUtils.isNotEmpty(apiMetadataList)) continue;
                    ApiMetadata apiMetadata = apiMetadataList.get(0);
                    ObjectNode tVersionDataNode = this.mapper.createObjectNode();
                    ObjectMapper objectMapper = new ObjectMapper();
                    tVersionDataNode.set(apiVersion.getVersion(), objectMapper.readTree(apiMetadata.getMetadata()));
                    tDataMap.put("api_version_info", tVersionDataNode);
                    this.log.info((Object)("\u540c\u6b65\u65b0\u589e\u4fe1\u606f\u81f3MQ\u5f00\u59cb_API\u540d\u79f0:" + tApiName + ",API\u7248\u672c:" + apiVersion.getVersion() + ",API\u79df\u6237:" + tTenantId));
                    MQUtil.sendApiMetadata(this.sendMqMessage(tDataMap));
                    this.log.info((Object)("\u540c\u6b65\u65b0\u589e\u4fe1\u606f\u81f3MQ\u6210\u529f_API\u540d\u79f0:" + tApiName + ",API\u7248\u672c:" + apiVersion.getVersion() + ",API\u79df\u6237:" + tTenantId));
                    continue;
                }
                this.apiRelationDeleteService.deleteApiRelation(tUserId, tApiName, tTenantId);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

