/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.services.MdcCacheService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantProductUpdateProcessService {
    private static final Log log = LogFactory.getLog(TenantProductUpdateProcessService.class);
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private ProductDao productDao;
    @Autowired
    private MdcCacheService cacheService;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    @Transactional(rollbackFor={Exception.class}, value="mdcTransactionManager")
    @Async
    public void updateProductService(JsonNode tProductNode, List<Product> pListToUpdate) {
        for (Product tProduct : pListToUpdate) {
            if (!tProductNode.get("name").asText().equals(tProduct.getName()) || !tProductNode.get("uid").asText().equals(tProduct.getUid())) continue;
            ArrayNode tSrvInfoAryNode = (ArrayNode)tProductNode.get("services");
            log.info((Object)("\u4ea7\u54c1Id: " + tProduct.getId()));
            List<com.digiwin.metadatacache.model.Service> tCurrentServiceList = this.serviceDao.getByPrdId(tProduct.getId());
            ArrayList<String> tCurrentServiceNameList = new ArrayList<String>();
            for (com.digiwin.metadatacache.model.Service service : tCurrentServiceList) {
                tCurrentServiceNameList.add(service.getName());
            }
            this.serviceDao.removeByPrdId(tProduct.getId());
            if (!tSrvInfoAryNode.isArray()) continue;
            if (tProduct.getId() == null) {
                HashMap<String, String> tCondition = new HashMap<String, String>();
                tCondition.put("name", tProduct.getName());
                tCondition.put("uid", tProduct.getUid());
                tCondition.put("eai_uid", tProduct.getEaiUid());
                List<Product> tProductList = this.productDao.fetch(tCondition);
                if (tProductList != null && tProductList.size() != 0) {
                    tProduct.setId(tProductList.get(0).getId());
                }
            }
            ArrayList<com.digiwin.metadatacache.model.Service> tUpdateServiceList = new ArrayList<com.digiwin.metadatacache.model.Service>();
            ArrayList<String> tUpdateServiceNameList = new ArrayList<String>();
            for (JsonNode tSrvNode : tSrvInfoAryNode) {
                com.digiwin.metadatacache.model.Service tService = new com.digiwin.metadatacache.model.Service();
                tService.setBuildTime(Calendar.getInstance());
                tService.setProduct(tProduct);
                if (tSrvNode.get("version") != null && tSrvNode.get("version").asText().length() != 0) {
                    tService.setVersion(tSrvNode.get("version").asText());
                }
                tService.setName(tSrvNode.get("name").asText());
                tUpdateServiceList.add(tService);
                tUpdateServiceNameList.add(tSrvNode.get("name").asText());
            }
            this.serviceDao.saveServices(tUpdateServiceList);
            List tServiceNameDifferenceList = (List)CollectionUtils.disjunction(tCurrentServiceNameList, tUpdateServiceNameList);
            if (tProduct.getProductType().equals(ApiTypeEnum.standard.toString())) {
                for (String serviceName : tServiceNameDifferenceList) {
                    if (tCurrentServiceNameList.contains(serviceName)) {
                        this.removeServiceFromProductInCache(tProduct, serviceName, ApiTypeEnum.standard);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)tProduct.getTenantId())) continue;
                    this.addServiceFromProductInCache(tProduct, serviceName, ApiTypeEnum.standard);
                }
                continue;
            }
            for (String serviceName : tServiceNameDifferenceList) {
                if (tCurrentServiceNameList.contains(serviceName)) {
                    this.removeServiceFromProductInCache(tProduct, serviceName, ApiTypeEnum.agile);
                    continue;
                }
                this.addServiceFromProductInCache(tProduct, serviceName, ApiTypeEnum.agile);
            }
        }
    }

    public void removeProductList(List<Product> pProductList) {
        for (Product tProduct : pProductList) {
            List<com.digiwin.metadatacache.model.Service> tServiceRemoveList = this.serviceDao.getByPrdId(tProduct.getId());
            this.serviceDao.removeByPrdId(tProduct.getId());
            this.productDao.remove(tProduct.getId());
            this.eocIntgMappingDao.clearListWithLevel(tProduct.getTenantId(), tProduct.getUid(), "All");
            if (!CollectionUtils.isNotEmpty(tServiceRemoveList)) continue;
            if (tProduct.getProductType().equals(ApiTypeEnum.standard.toString())) {
                for (com.digiwin.metadatacache.model.Service tService : tServiceRemoveList) {
                    this.removeServiceFromProductInCache(tProduct, tService.getName(), ApiTypeEnum.standard);
                }
                continue;
            }
            for (com.digiwin.metadatacache.model.Service tService : tServiceRemoveList) {
                this.removeServiceFromProductInCache(tProduct, tService.getName(), ApiTypeEnum.agile);
            }
        }
    }

    private void removeServiceFromProductInCache(Product pProduct, String pServiceName, ApiTypeEnum pSearchProdTypeEnum) {
        String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":" + pServiceName;
        if (pSearchProdTypeEnum.equals((Object)ApiTypeEnum.standard)) {
            tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pProduct.getTenantId();
            Map tProductServiceMapFromCache = (Map)this.cacheService.get(tKey);
            String tProductKey = pProduct.getName() + ":" + pProduct.getUid() + ":" + pProduct.getEaiUid();
            if (tProductServiceMapFromCache != null && tProductServiceMapFromCache.get(tProductKey) != null) {
                ArrayList<String> tServiceToRemove = new ArrayList<String>();
                for (String tServiceString : ((List)tProductServiceMapFromCache.get(tProductKey)).subList(1, ((List)tProductServiceMapFromCache.get(tProductKey)).size())) {
                    if (!tServiceString.contains(pServiceName)) continue;
                    tServiceToRemove.add(tServiceString);
                    log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u7522\u54c1\u4e2d\u7684\u670d\u52d9)\uff1akey = " + tKey));
                }
                if (!tServiceToRemove.isEmpty()) {
                    ((List)tProductServiceMapFromCache.get(tProductKey)).removeAll(tServiceToRemove);
                    this.cacheService.setSync(tKey, tProductServiceMapFromCache);
                }
            }
        } else {
            Map tProductServiceMapFromCache = (Map)this.cacheService.get(tKey);
            if (null != tProductServiceMapFromCache) {
                String tProductKey = pProduct.getName() + ":" + pProduct.getUid();
                tProductServiceMapFromCache.remove(tProductKey);
                this.cacheService.setSyncTimeOut(tKey, tProductServiceMapFromCache, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
            }
        }
    }

    private void addServiceFromProductInCache(Product pProduct, String pServiceString, ApiTypeEnum pSearchProdTypeEnum) {
        String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":" + pServiceString;
        if (pSearchProdTypeEnum.equals((Object)ApiTypeEnum.standard)) {
            tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pProduct.getTenantId();
            Map tProductServiceMapFromCache = (Map)this.cacheService.get(tKey);
            String tProductKey = pProduct.getName() + ":" + pProduct.getUid() + ":" + pProduct.getEaiUid();
            if (tProductServiceMapFromCache != null && tProductServiceMapFromCache.get(tProductKey) != null) {
                log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u66f4\u65b0\u5feb\u53d6(\u7522\u54c1\u4e2d\u7684\u670d\u52d9)\uff1akey = " + tKey));
                ((List)tProductServiceMapFromCache.get(tProductKey)).add(pServiceString);
                this.cacheService.setSync(tKey, tProductServiceMapFromCache);
            }
        } else {
            Map tProductServiceMapFromCache = (Map)this.cacheService.get(tKey);
            if (null != tProductServiceMapFromCache) {
                String tProductKey = pProduct.getName() + ":" + pProduct.getUid();
                String tProductFullInfo = pProduct.getName() + "/" + pProduct.getUid() + "/" + pProduct.getEaiUid() + "/" + pProduct.getVersion() + "/" + pProduct.getIp() + "/" + pProduct.getApid() + "/" + pProduct.getGatewayId();
                tProductServiceMapFromCache.put(tProductKey, tProductFullInfo);
                this.cacheService.setSyncTimeOut(tKey, tProductServiceMapFromCache, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
            }
        }
    }
}

