/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.config;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
public class MdcHibernateConfig {
    @Value(value="${hibernate.cache.use_second_level_cache:false}")
    private String use_second_level_cache;
    @Value(value="${hibernate.cache.use_query_cache:false}")
    private String use_query_cache;

    @Bean(value={"mdcDataSource"})
    @ConfigurationProperties(prefix="mdc.spring.datasource")
    public DruidDataSource mdcDataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        return druidDataSource;
    }

    @Bean(value={"mdcLocalSessionFactoryBean"})
    public LocalSessionFactoryBean mdcLocalSessionFactoryBean(@Qualifier(value="mdcDataSource") DataSource dataSource) {
        LocalSessionFactoryBean factoryBean = new LocalSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        factoryBean.setHibernateProperties(this.hibernateProperties());
        factoryBean.setPackagesToScan(new String[]{"com.digiwin.metadatacache.model"});
        return factoryBean;
    }

    @Bean(value={"mdcTransactionManager"})
    public HibernateTransactionManager mdcHibernateTransactionManager(@Qualifier(value="mdcLocalSessionFactoryBean") SessionFactory localSessionFactoryBean) {
        HibernateTransactionManager hibernateTransactionManager = new HibernateTransactionManager(localSessionFactoryBean);
        return hibernateTransactionManager;
    }

    private Properties hibernateProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.hbm2ddl.auto", "update");
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQL8Dialect");
        properties.put("hibernate.show_sql", "true");
        properties.put("hibernate.format_sql", "true");
        properties.put("hibernate.query.substitutions", "true 'Y', false 'N'");
        properties.put("hibernate.cache.use_second_level_cache", this.use_second_level_cache);
        properties.put("hibernate.cache.use_query_cache", this.use_query_cache);
        properties.put("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.EhCacheRegionFactory");
        return properties;
    }
}

