/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.AssetPropertyDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.model.AssetProperty;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class AssetPropertyDaoImpl
extends GenericDaoImpl<AssetProperty, Long>
implements AssetPropertyDao {
    public AssetPropertyDaoImpl() {
        super(AssetProperty.class);
    }

    @Override
    public void deleteByInfo(final Map<String, String> pCondition) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                String tenantId = (String)pCondition.get("tenant_id");
                String sql = "delete AssetProperty where code = :code and propertyType= :propertyType";
                if (null != tenantId) {
                    sql = sql + " and tenantId = :tenantId";
                }
                Query tQueryRemoveApi = pSession.createQuery(sql);
                tQueryRemoveApi.setParameter("code", pCondition.get("code"));
                tQueryRemoveApi.setParameter("propertyType", pCondition.get("property_type"));
                if (null != tenantId) {
                    tQueryRemoveApi.setParameter("code", (Object)tenantId);
                }
                tQueryRemoveApi.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public List<AssetProperty> getAssetPropertyByInfo(Map<String, String> pCondition) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(AssetProperty.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"code", (Object)pCondition.get("code")));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"propertyType", (Object)pCondition.get("property_type")));
        String tenantId = pCondition.get("tenant_id");
        if (null != tenantId) {
            tDetachedCriteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)tenantId));
        } else {
            tDetachedCriteria.add(Restrictions.isNull((String)"tenantId"));
        }
        return this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }
}

