/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class ServiceDaoImpl
extends GenericDaoImpl<com.digiwin.metadatacache.model.Service, Long>
implements ServiceDao {
    public ServiceDaoImpl() {
        super(com.digiwin.metadatacache.model.Service.class);
    }

    @Override
    public List<com.digiwin.metadatacache.model.Service> fetch(final Map<String, String> pConditions) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<com.digiwin.metadatacache.model.Service>>(){

            public List<com.digiwin.metadatacache.model.Service> doInHibernate(Session pSession) throws HibernateException {
                Criteria tCriteria = pSession.createCriteria(com.digiwin.metadatacache.model.Service.class);
                tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                if (pConditions.containsKey("version")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"version", pConditions.get("version")));
                }
                if (pConditions.containsKey("name")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"name", pConditions.get("name")));
                }
                return tCriteria.list();
            }
        });
    }

    @Override
    public List<com.digiwin.metadatacache.model.Service> getByPrdId(final Long pPrdId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<com.digiwin.metadatacache.model.Service>>(){

            public List<com.digiwin.metadatacache.model.Service> doInHibernate(Session pSession) throws HibernateException {
                Criteria tCriteria = pSession.createCriteria(com.digiwin.metadatacache.model.Service.class);
                tCriteria.add((Criterion)Restrictions.eq((String)"product.id", (Object)pPrdId));
                return tCriteria.list();
            }
        });
    }

    @Override
    public com.digiwin.metadatacache.model.Service getByPrdIdAndServiceName(Long pPrdId, String pServiceName) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(com.digiwin.metadatacache.model.Service.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"product.id", (Object)pPrdId));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"name", (Object)pServiceName));
        List tServices = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (tServices.size() == 0) {
            return null;
        }
        return (com.digiwin.metadatacache.model.Service)tServices.get(0);
    }

    @Override
    public void removeByPrdId(final Long pPrdId) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<com.digiwin.metadatacache.model.Service>(){

            public com.digiwin.metadatacache.model.Service doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete Service where product.id is :productId");
                tQ.setParameter("productId", (Object)pPrdId);
                tQ.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public void saveServices(final List<com.digiwin.metadatacache.model.Service> pServices) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                for (com.digiwin.metadatacache.model.Service service : pServices) {
                    pSession.merge((Object)service);
                }
                return pSession;
            }
        });
    }

    @Override
    public List<com.digiwin.metadatacache.model.Service> getByServiceNames(List<String> serviceNames) {
        return (List)this.getHibernateTemplate().execute(pSession -> {
            Criteria tCriteria = pSession.createCriteria(com.digiwin.metadatacache.model.Service.class);
            tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            tCriteria.add(Restrictions.in((String)"name", (Collection)serviceNames));
            return tCriteria.list();
        });
    }

    @Override
    public List<com.digiwin.metadatacache.model.Service> getByPrdAndServiceName(String prod, String prodUid, String pServiceName) {
        return (List)this.getHibernateTemplate().execute(session -> {
            StringBuilder tStrBuild = new StringBuilder();
            tStrBuild.append("SELECT ver FROM Service ver JOIN ver.product p ");
            HashMap<String, Object> condition = new HashMap<String, Object>();
            tStrBuild.append("WHERE ver.name = :serviceName ");
            condition.put("serviceName", pServiceName);
            if (StringUtils.isNotBlank((CharSequence)prod)) {
                tStrBuild.append("AND p.name = :prod ");
                condition.put("prod", prod);
            }
            if (StringUtils.isNotBlank((CharSequence)prodUid)) {
                tStrBuild.append("AND p.uid = :prodUid");
                condition.put("prodUid", prodUid);
            }
            Query tQuery = session.createQuery(tStrBuild.toString());
            condition.forEach((key, val) -> tQuery.setParameter(key, val));
            return tQuery.list();
        });
    }
}

