/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.exception.TenantTypeRetrievedException;
import com.digiwin.metadatacache.exception.TokenNotRetrievedException;
import com.digiwin.metadatacache.exception.UserInfoRetrievedException;
import com.digiwin.metadatacache.exception.UserRoleRetrievedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IamVerifyService {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private DWHttpClient dwHttpClient;
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Value(value="${supportTenantV2:false}")
    private String supportTenantV2;
    ObjectMapper mapper = new ObjectMapper();

    public String getUserName(String pUserToken) throws Exception {
        Map<String, String> tResponse = this.getUserInfo(pUserToken);
        String tUserName = null;
        if (tResponse.get("name") != null) {
            tUserName = tResponse.get("name");
        }
        return tUserName;
    }

    public Map<String, String> getUserInfo(String pUserToken) throws Exception {
        HashMap<String, String> tResult = new HashMap<String, String>();
        try {
            JsonNode tResponseNode = this.analyzeToken(pUserToken);
            if (tResponseNode.get("tenantId") != null) {
                tResult.put("tenantId", tResponseNode.get("tenantId").asText());
            }
            if (tResponseNode.get("id") != null) {
                tResult.put("userId", tResponseNode.get("id").asText());
            }
            if (tResponseNode.get("name") != null) {
                tResult.put("name", tResponseNode.get("name").asText());
            }
        }
        catch (Exception e) {
            throw new UserInfoRetrievedException(this.getClass());
        }
        return tResult;
    }

    private JsonNode analyzeToken(String pToken) throws Exception {
        URI tUri = DWURIBuilder.create((String)(MdcApplicationParameter._IAM_HOST + "/api/iam/v2/identity/token/analyze")).build();
        HttpPost tPost = new HttpPost(tUri);
        tPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
        tPost.setHeader("token", pToken);
        if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
            tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
        }
        String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false));
        return this.mapper.readTree(tResponse);
    }

    public boolean isSuperAdmin(String userId, String token) throws Exception {
        try {
            URI tIamTargetUri = DWURIBuilder.create((String)(MdcApplicationParameter._IAM_HOST + "/api/iam/v2/user/role")).build();
            HttpPost tPost = new HttpPost(tIamTargetUri);
            ObjectNode objectNode = this.mapper.createObjectNode();
            objectNode.put("id", userId);
            StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
            entity.setContentEncoding("UTF-8");
            tPost.setEntity((HttpEntity)entity);
            tPost.setHeader("token", token);
            tPost.setHeader("digi-middleware-auth-user", token);
            tPost.setHeader("Content-Type", "application/json");
            tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false));
            JsonNode tResultNode = this.mapper.readTree(tResponse);
            ArrayNode tRolesNode = (ArrayNode)tResultNode.get("roles");
            for (JsonNode node : tRolesNode) {
                if (!node.get("id").asText().equals("superadmin")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new UserRoleRetrievedException(e, this.getClass());
        }
    }

    public boolean isPersonalTenant(String token) throws Exception {
        try {
            String tResponse;
            JsonNode tResultNode;
            int tEnterpriseType;
            URI tIamTargetUri = DWURIBuilder.create((String)(MdcApplicationParameter._IAM_HOST + "/api/iam/v2/tenant/current")).build();
            HttpPost tPost = new HttpPost(tIamTargetUri);
            tPost.setHeader("token", token);
            tPost.setHeader("digi-middleware-auth-user", token);
            tPost.setHeader("Content-Type", "application/json");
            tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            return (tEnterpriseType = (tResultNode = this.mapper.readTree(tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false)))).get("tenant").get("enterpriseType").asInt()) == 0;
        }
        catch (Exception e) {
            throw new TenantTypeRetrievedException(e, this.getClass());
        }
    }

    public String getCurrentTenantVersion(String pTenantId) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.supportTenantV2) && "false".equals(this.supportTenantV2)) {
            return "v1";
        }
        if (DWServiceContext.getContext().getProfile() == null || MapUtils.isEmpty((Map)DWServiceContext.getContext().getProfile())) {
            DWServiceContext.getContext().setProfile(new HashMap());
        }
        if (!DWServiceContext.getContext().getProfile().containsKey("version")) {
            Map headers = DWServiceContext.getContext().getRequestHeader();
            String tToken = MapUtils.getString((Map)headers, (Object)"token");
            if (StringUtils.isEmpty((CharSequence)tToken)) {
                tToken = this.getTokenByTenant(pTenantId);
            }
            DWServiceContext.getContext().getProfile().put("version", this.getTenantOperationUnitVersion(tToken));
        }
        return MapUtils.getString((Map)DWServiceContext.getContext().getProfile(), (Object)"version");
    }

    public String getCurrentTenantVersionByToken(String token) throws Exception {
        JsonNode simpleByToken = this.getCurrentTenantSimpleByToken(token);
        JsonNode jsonNode = simpleByToken.get("data");
        if (jsonNode.get("version") == null) {
            return "v1";
        }
        return jsonNode.get("version").asText();
    }

    public String getTenantOperationUnitVersion(String token) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return "v1";
        }
        JsonNode simpleByToken = this.getCurrentTenantSimpleByToken(token);
        JsonNode jsonNode = simpleByToken.get("data");
        if (jsonNode.get("version") == null) {
            return "v1";
        }
        return jsonNode.get("version").asText();
    }

    public JsonNode getCurrentTenantSimpleByToken(String pToken) throws Exception {
        try {
            URI tUri = DWURIBuilder.create((String)(MdcApplicationParameter._IAM_HOST + "/api/iam/v2/tenant/current/simple")).build();
            HttpGet tGet = new HttpGet(tUri);
            tGet.setHeader("Content-Type", "application/json;charset=UTF-8");
            tGet.setHeader("digi-middleware-auth-user", pToken);
            tGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            String tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tGet, String.class, new DWRequestOption(false));
            return this.mapper.readTree(tResponse);
        }
        catch (Exception e) {
            this.log.error((Object)"Route=>IamVerifyService method=getCurrentTenantSimpleByToken error:", (Throwable)e);
            throw new TenantTypeRetrievedException(e, this.getClass());
        }
    }

    public String getTokenByTenant(String tenantId) throws Exception {
        try {
            URI tIamTargetUri = DWURIBuilder.create((String)"iam", (String)"/api/iam/v2/identity/login/internal").build();
            HttpPost tPost = new HttpPost(tIamTargetUri);
            HashMap<String, String> tRequestEntity = new HashMap<String, String>();
            tRequestEntity.put("identityType", "internal");
            tRequestEntity.put("userId", "integration");
            tRequestEntity.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
            tRequestEntity.put("tenantId", tenantId);
            tPost.setEntity((HttpEntity)new DWJsonEntity(tRequestEntity));
            tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            Map tResponseEntity = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
            return (String)tResponseEntity.get("token");
        }
        catch (DWHttpFailedException e) {
            Map tFailedEntity = (Map)e.getEntity(Map.class);
            String tMsg = String.format("IAM response: %s", tFailedEntity.get("message"));
            throw new TokenNotRetrievedException(tMsg, this.getClass());
        }
        catch (Exception e) {
            throw new TokenNotRetrievedException(e, this.getClass());
        }
    }
}

