/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class LoadCacheService {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final RemovalListener<String, Map<String, ObjectNode>> listener = notification -> System.err.println("remove key:" + (String)notification.getKey());
    private static final LoadingCache<String, Map<String, ObjectNode>> loadingCache = CacheBuilder.newBuilder().maximumSize(300L).removalListener(listener).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, ObjectNode>>(){

        public Map<String, ObjectNode> load(String key) {
            return new HashMap<String, ObjectNode>();
        }
    });

    public void saveData(String key, String tenantId, ObjectNode value) {
        Map map;
        try {
            map = (Map)loadingCache.get((Object)key);
        }
        catch (ExecutionException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (map.size() > 30) {
            map.clear();
        }
        map.put(tenantId, value);
        loadingCache.put((Object)key, (Object)map);
    }

    public ObjectNode getData(String key, String tenantId) {
        try {
            Map map = (Map)loadingCache.getIfPresent((Object)key);
            if (null != map) {
                return (ObjectNode)map.get(tenantId);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("\u672c\u5730\u5feb\u53d6\u63d2\u53d9\u5f02\u5e38: key " + key + "tenantId " + tenantId));
        }
        return null;
    }

    public void removeData(String key) {
        loadingCache.invalidate((Object)key);
    }

    public void removeAllData() {
        loadingCache.invalidateAll();
    }

    public Map<String, Object> showData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry stringMapEntry : loadingCache.asMap().entrySet()) {
            map.put((String)stringMapEntry.getKey(), stringMapEntry.getValue());
        }
        return map;
    }
}

