/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.util.StringUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.stereotype.Service;

@Service
public class RedissonService {
    private final Log log = LogFactory.getLog(this.getClass());
    private RedissonClient client;
    private boolean isEnable = false;

    @PostConstruct
    public void init() {
        if (!StringUtil.isEmpty(MdcApplicationParameter._REDIS_HOST)) {
            final Config tConfig = new Config();
            SingleServerConfig tServerConfig = tConfig.useSingleServer();
            String tAddress = String.format("redis://%s:%s", MdcApplicationParameter._REDIS_HOST, MdcApplicationParameter._REDIS_PORT);
            tServerConfig.setAddress(tAddress);
            if (!StringUtil.isEmpty(MdcApplicationParameter._REDIS_PASSWORD)) {
                tServerConfig.setPassword(MdcApplicationParameter._REDIS_PASSWORD);
            }
            tServerConfig.setDatabase(MdcApplicationParameter._REDIS_DB.intValue());
            this.redissonCreate(tConfig);
            if (this.client == null) {
                Timer tTimer = new Timer();
                tTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RedissonService.this.redissonCreate(tConfig);
                    }
                }, TimeUnit.SECONDS.toMillis(10L), TimeUnit.SECONDS.toMillis(10L));
            }
        }
    }

    private void redissonCreate(Config pConfig) {
        try {
            this.client = Redisson.create((Config)pConfig);
            this.log.info((Object)"Redis connect success");
            this.setEnable(true);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean lock(String pLockKey) throws InterruptedException {
        RLock tLock = this.client.getFairLock(pLockKey);
        return tLock.tryLock(120L, 120L, TimeUnit.SECONDS);
    }

    public void unLock(String pLockKey) {
        RLock tLock = this.client.getFairLock(pLockKey);
        tLock.unlock();
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public RedissonClient getClient() {
        return this.client;
    }
}

