/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        if (null == obj) {
            return null;
        }
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toJavaObj(String json, Class<T> tClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toJavaObj(JsonNode json, Class<T> tClass) {
        if (null == json) {
            return null;
        }
        try {
            return (T)MAPPER.treeToValue((TreeNode)json, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> toJavaList(String jsonArray, Class<T> elementType) {
        if (StringUtils.isBlank((CharSequence)jsonArray)) {
            return null;
        }
        try {
            CollectionType listType = TypeFactory.defaultInstance().constructCollectionType(List.class, elementType);
            return (List)MAPPER.readValue(jsonArray, (JavaType)listType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode readJsonNode(InputStream in) {
        if (null == in) {
            return null;
        }
        try {
            return MAPPER.readTree(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode readJsonNode(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectNode createJsonObject() {
        return MAPPER.createObjectNode();
    }

    public static Object toObjectWhenIsJson(String message) {
        boolean isArrayFormat;
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        String tmp = StringUtils.trimToEmpty((String)message);
        boolean isObjectFormat = tmp.startsWith("{") && tmp.startsWith("}");
        boolean bl = isArrayFormat = tmp.startsWith("[") && tmp.startsWith("]");
        if (!isObjectFormat && !isArrayFormat) {
            return message;
        }
        try {
            return MAPPER.readTree(message);
        }
        catch (Exception e) {
            return message;
        }
    }

    public static ObjectMapper getMAPPER() {
        return MAPPER;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

