/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.validator;

import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.JsonFormatValidationException;
import com.digiwin.metadatacache.exception.JsonSyntaxValidationException;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.util.Scanner;

public class JsonSchemaValidator {
    public ValidatorResult validate(String pMessage, String pSchemaFileName) throws Exception {
        ValidatorResult tResult = new ValidatorResult();
        try {
            Scanner reader = new Scanner(this.getClass().getResourceAsStream("/schema/" + pSchemaFileName));
            StringBuilder builder = new StringBuilder();
            while (reader.hasNextLine()) {
                builder.append(reader.nextLine());
            }
            String jsonSchema = builder.toString();
            reader.close();
            JsonNode schemaNode = JsonLoader.fromString((String)jsonSchema);
            JsonNode jsonNode = JsonLoader.fromString((String)pMessage);
            ProcessingReport report = JsonSchemaFactory.byDefault().getValidator().validateUnchecked(schemaNode, jsonNode);
            if (report.isSuccess()) {
                tResult.setState(ValidateStateEnum.SUCCESS);
                tResult.setJsonContent(jsonNode);
                return tResult;
            }
            for (ProcessingMessage processMessage : report) {
                if (LogLevel.WARNING.equals((Object)processMessage.getLogLevel())) continue;
                tResult.setState(ValidateStateEnum.FORMAT_ERROR);
                JsonNode instanceNode = processMessage.asJson().get("instance").get("pointer");
                tResult.setErrorNodePath(instanceNode.toString().replace("\"", ""));
                tResult.setMessage(processMessage.getMessage().replace("\"", ""));
                throw new JsonFormatValidationException(tResult.getMessage() + " at " + tResult.getErrorNodePath(), this.getClass());
            }
            throw new JsonFormatValidationException(this.getClass());
        }
        catch (JsonParseException e) {
            throw new JsonSyntaxValidationException(e, this.getClass());
        }
    }
}

