/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.mq;

import com.digiwin.athena.sccommon.mq.SCMessagePostProcessor;
import java.util.Map;
import java.util.UUID;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQProducer {
    @Autowired
    private RabbitTemplate template;

    public String sendMessage(String exchange, String routeKey, Map<String, Object> paramMap) {
        String messageId = UUID.randomUUID().toString();
        this.template.convertAndSend(exchange, routeKey, paramMap, new CorrelationData(messageId));
        return messageId;
    }

    public String sendMessage(String exchange, String routeKey, Map<String, Object> paramMap, int ttl) {
        SCMessagePostProcessor messageProcessor = new SCMessagePostProcessor(ttl);
        String messageId = UUID.randomUUID().toString();
        this.template.convertAndSend(exchange, routeKey, paramMap, (MessagePostProcessor)messageProcessor, new CorrelationData(messageId));
        return messageId;
    }

    public String convertAndSend(String exchange, String routeKey, Object message) {
        String messageId = UUID.randomUUID().toString();
        this.template.convertAndSend(exchange, routeKey, message, new CorrelationData(messageId));
        return messageId;
    }

    public String convertAndSend(String exchange, String routeKey, Object message, int ttl) {
        SCMessagePostProcessor messageProcessor = new SCMessagePostProcessor(ttl);
        String messageId = UUID.randomUUID().toString();
        this.template.convertAndSend(exchange, routeKey, message, (MessagePostProcessor)messageProcessor, new CorrelationData(messageId));
        return messageId;
    }
}

