/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.workflow.impl;

import com.digiwin.athena.sccommon.dao.WorkflowDao;
import com.digiwin.athena.sccommon.dto.WorkFlowQueryDto;
import com.digiwin.athena.sccommon.pojo.model.WorkFlowModel;
import com.digiwin.athena.sccommon.service.mongo.AbstractService;
import com.digiwin.athena.sccommon.service.workflow.IWorkFlowService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowService
extends AbstractService<WorkflowDao, WorkFlowModel>
implements IWorkFlowService {
    private static final String START_TIME = "startTime";
    @Autowired
    private MongoTemplate template;

    @Override
    public Page<WorkFlowModel> queryWorkFlowModels(WorkFlowQueryDto workFlowQueryDto) {
        Query query = new Query((CriteriaDefinition)this.buildQueryCondition(workFlowQueryDto));
        int pageNo = workFlowQueryDto.getPageNo() <= 0 ? 1 : workFlowQueryDto.getPageNo();
        PageRequest pageable = PageRequest.of((int)(pageNo - 1), (int)workFlowQueryDto.getPageSize());
        query.with((Pageable)pageable);
        query.with(new Sort(Sort.Direction.DESC, new String[]{START_TIME}));
        List workFlowModels = this.template.find(query, WorkFlowModel.class);
        long count = this.template.count(query, WorkFlowModel.class);
        return PageableExecutionUtils.getPage((List)workFlowModels, (Pageable)pageable, () -> count);
    }

    private Criteria buildQueryCondition(WorkFlowQueryDto workFlowQueryDto) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getWid())) {
            criteria.and("wid").is((Object)workFlowQueryDto.getWid());
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getTenantId())) {
            criteria.and("tenantId").is((Object)workFlowQueryDto.getTenantId());
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getTemplateId())) {
            criteria.and("templateId").is((Object)workFlowQueryDto.getTemplateId());
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getEocCompanyId())) {
            criteria.and("eocCompanyId").is((Object)workFlowQueryDto.getEocCompanyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getEocRegionId())) {
            criteria.and("eocRegionId").is((Object)workFlowQueryDto.getEocRegionId());
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowQueryDto.getEocSiteId())) {
            criteria.and("eocSiteId").is((Object)workFlowQueryDto.getEocSiteId());
        }
        if (workFlowQueryDto.getStartTime() != null && workFlowQueryDto.getEndTime() != null) {
            criteria.and(START_TIME).gte((Object)workFlowQueryDto.getStartTime()).lte((Object)workFlowQueryDto.getEndTime());
        } else if (workFlowQueryDto.getStartTime() != null) {
            criteria.and(START_TIME).gte((Object)workFlowQueryDto.getStartTime());
        } else if (workFlowQueryDto.getEndTime() != null) {
            criteria.and(START_TIME).lte((Object)workFlowQueryDto.getEndTime());
        }
        if (workFlowQueryDto.getStatus() > -1) {
            criteria.and("status").is((Object)workFlowQueryDto.getStatus());
        }
        return criteria;
    }
}

