/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.atomic.impl;

import com.digiwin.athena.sccommon.exception.CustomException;
import com.digiwin.athena.sccommon.service.atomic.AtomicOperationService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtomicOperationServiceImpl
implements AtomicOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicOperationServiceImpl.class);
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public <T> T execute(Supplier<T> operation, String lockKey, long waitTime, TimeUnit unit) {
        RLock lock = null;
        try {
            lock = this.redissonClient.getLock(lockKey);
            boolean isGetLock = lock.tryLock(waitTime, unit);
            if (!isGetLock) {
                lock = null;
                throw new CustomException("\u5df2\u6709\u8bf7\u6c42\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            LOGGER.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u9501\u540d\u79f0\uff1a[{}]", (Object)lockKey);
            T t = operation.get();
            return t;
        }
        catch (RedisException e) {
            LOGGER.error("\u83b7\u53d6\u9501\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01\u9501\u540d\u79f0: " + lockKey, (Throwable)e);
            throw new CustomException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        catch (InterruptedException e) {
            LOGGER.error("\u83b7\u53d6\u9501\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01\u9501\u540d\u79f0: " + lockKey, (Throwable)e);
            Thread.currentThread().interrupt();
            throw new CustomException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        finally {
            if (lock != null) {
                this.unlock(lock);
            }
        }
    }

    private void unlock(RLock lock) {
        try {
            lock.unlock();
            LOGGER.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u9501\u540d\u79f0\uff1a[{}]", (Object)lock.getName());
        }
        catch (Exception e) {
            LOGGER.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u9501\u540d\u79f0\uff1a[" + lock.getName() + "]", (Throwable)e);
            throw new CustomException("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }
}

