/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.mongo.impl;

import com.digiwin.athena.sccommon.dao.WorkflowDao;
import com.digiwin.athena.sccommon.pojo.bo.PageBO;
import com.digiwin.athena.sccommon.pojo.model.WorkFlowModel;
import com.digiwin.athena.sccommon.service.mongo.AbstractService;
import com.digiwin.athena.sccommon.service.mongo.IWorkflowPersistenceService;
import com.mongodb.client.result.DeleteResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkflowPersistenceServiceImpl
extends AbstractService<WorkflowDao, WorkFlowModel>
implements IWorkflowPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowPersistenceServiceImpl.class);
    @Autowired
    private MongoTemplate template;

    @Override
    public Page<WorkFlowModel> queryInstance(int status, int pageNo) {
        Criteria criteria = new Criteria();
        criteria.and("status").is((Object)status);
        Query query = new Query((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)(pageNo - 1), (int)100);
        query.with((Pageable)pageable);
        query.with(new Sort(Sort.Direction.ASC, new String[]{"startTime"}));
        return PageableExecutionUtils.getPage((List)this.template.find(query, WorkFlowModel.class), (Pageable)pageable, () -> this.template.count(query, WorkFlowModel.class));
    }

    @Override
    public long deleteInstance(WorkFlowModel workFlowModel, PageBO pageBO) {
        long deleteCounts = 0L;
        for (int pageNumber = 1; pageNumber <= pageBO.getTotalPage(); ++pageNumber) {
            Criteria criteria = new Criteria();
            criteria.and("startTime").lte((Object)workFlowModel.getStartTime());
            Query query = new Query((CriteriaDefinition)criteria);
            PageRequest pageable = PageRequest.of((int)0, (int)pageBO.getPageSize());
            query.with((Pageable)pageable);
            query.with(new Sort(Sort.Direction.ASC, new String[]{"startTime"}));
            DeleteResult deleteResult = this.template.remove(query, WorkFlowModel.class);
            deleteCounts += deleteResult.getDeletedCount();
            if (deleteResult.getDeletedCount() == 0L) break;
        }
        return deleteCounts;
    }

    @Override
    public WorkFlowModel selectOne(String wid, String rid) {
        Criteria criteria = new Criteria();
        criteria.and("wid").is((Object)wid);
        criteria.and("rid").is((Object)rid);
        Query query = new Query((CriteriaDefinition)criteria);
        return (WorkFlowModel)this.template.findOne(query, WorkFlowModel.class);
    }

    @Override
    public long deleteOne(String wid, String rid) {
        WorkFlowModel workflowModel = new WorkFlowModel();
        workflowModel.setWid(wid);
        workflowModel.setRid(rid);
        Criteria.where((String)"wid").is((Object)workflowModel.getWid());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"rid").is((Object)workflowModel.getRid()));
        DeleteResult deleteResult = this.template.remove(query, WorkFlowModel.class);
        return deleteResult.getDeletedCount();
    }
}

