package com.digiwin.athena.schedulemanager.producer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.schedulemanager.core.config.RabbitMQProperty;
import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import com.digiwin.athena.schedulemanager.core.util.AgileParamsAssemble;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.service.client.impl.CustomHttpClient;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.UUID;

/**
 * @description: mq消息生产
 * @author: zhangww
 * @date: 2021/6/11 2:27
 */
@Component("scheduleMessageProducer")
public class MessageProducer {

    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProducer.class);

    public static final String ROUTING_KEY = "routingKey.schedule.execute";

    public static final String AGILE_CALLER = "agileSubscribe";

    @Autowired
    @Qualifier("scheduleRabbitTemplate")
    private RabbitTemplate template;


    @Autowired
    @Qualifier("scheduleRabbitMQProperty")
    private RabbitMQProperty rabbitMQProperty;

    @Autowired
    @Qualifier("scheduleCustomHttpClient")
    private CustomHttpClient customHttpClient;

    public String sendMessage(Map<String, Object> paramMap) {
        String messageId = UUID.randomUUID().toString();
        String routingKey = StringUtil.isEmpty(MapUtils.getString(paramMap, ScheduleConstant.CALLER))? rabbitMQProperty.getRoutingKey() : ROUTING_KEY + MapUtils.getString(paramMap, ScheduleConstant.CALLER);
        //LOGGER.info("MessageProducer#sendMessage caller :{}, ruleId :{}",MapUtils.getString(paramMap, ScheduleConstant.CALLER), MapUtils.getString(paramMap, "ruleId"));
        if(AGILE_CALLER.equals(MapUtils.getString(paramMap, ScheduleConstant.CALLER))){
            LOGGER.info("MessageProducer#sendMessage trigger send message :{}, exchangeAgile :{}, agileRoutingKey :{}, v-host :{}",
                    paramMap, rabbitMQProperty.getExchangeAgile(), rabbitMQProperty.getRoutingKeyAgile(), rabbitMQProperty.getVirtualHost());
            String tenantId = MapUtils.getString(paramMap, ScheduleConstant.TENANTID);
            if(StringUtils.isBlank(tenantId)){
                return "";
            }

            String realTimeTenantToken = customHttpClient.getRealTimeTenantToken(tenantId);

            MessageProperties messageProperties = new MessageProperties();
            messageProperties.setHeader("token",realTimeTenantToken);
            messageProperties.setHeader("routerKey",tenantId);
            //LOGGER.info("MessageProducer#sendMessage schedule_param :{}",MapUtils.getMap(paramMap, ScheduleConstant.SCHEDULE_CUSTOM_PARAM));

            Map resultMap = AgileParamsAssemble.assembleMqMesssage(MapUtils.getMap(paramMap, ScheduleConstant.SCHEDULE_CUSTOM_PARAM));

           // LOGGER.info("MessageProducer#sendMessage tenantId :{}, token :{}, resultMap :{} ",tenantId, realTimeTenantToken, resultMap);

            Message message = new Message(JSONObject.toJSONString(resultMap).getBytes(), messageProperties);

            template.convertAndSend(rabbitMQProperty.getExchangeAgile(), rabbitMQProperty.getRoutingKeyAgile(), message, new CorrelationData(messageId));
        }else {
            template.convertAndSend(rabbitMQProperty.getExchange(), routingKey, paramMap, new CorrelationData(messageId));
        }
        return messageId;
    }
}
