package com.digiwin.athena.schedulemanager.core.exception;

import com.digiwin.athena.schedulemanager.core.message.ErrorCode;

/**
 * @description: 适用于模组中的业务异常场景。例如：解析参数错误，调用sdk返回结果异常，解析元数据失败，通过逻辑判断后不符合预期的异常场景。
 * @author: dongwh
 * @date: 2022/1/6 14:54
 */
public class BusinessException extends UnRetryAbleException {

    /**
     * 构造基本异常
     * @param errorCode
     */
    public BusinessException(ErrorCode errorCode) {
        super(errorCode.getCode(), errorCode.getMessage());
    }
}
