package com.digiwin.athena.schedulemanager.core.util;

import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import org.apache.commons.collections.MapUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AgileParamsAssemble {


    public static Map<String,Object> assembleMqMesssage(Map<String,Object> msgExt){

        String userId = MapUtils.getString(msgExt, ScheduleConstant.USER_ID);
        String question = MapUtils.getString(msgExt, ScheduleConstant.QUESTION);
        String tenantId = MapUtils.getString(msgExt, ScheduleConstant.TENANTID);
        String tenantName = MapUtils.getString(msgExt, ScheduleConstant.TENANTNAME);

        Map<String, Object> fromPartMap = new HashMap(4);
        fromPartMap.put("userId",userId);

        Map<String, Object> toPartMap = new HashMap(4);
        toPartMap.put("appCode","asada");

        Map<String, Object> msgBodyPartMap = new HashMap(4);
        msgBodyPartMap.put("text", question);

        Map<String, Object> msgExtPartMap = new HashMap(msgExt);
        msgExtPartMap.put("type", "agileSubscribe");
        msgExtPartMap.put("multiDialogue", false);
        msgExtPartMap.put(ScheduleConstant.TENANTID, tenantId);
        msgExtPartMap.put(ScheduleConstant.TENANTNAME, tenantName);

        Map<String, Object> resultMap = new HashMap(16);
        resultMap.put("from", fromPartMap);
        resultMap.put("to", toPartMap);
        resultMap.put("msgBody", msgBodyPartMap);
        resultMap.put("msgExt", msgExtPartMap);
        resultMap.put("msgType", "agileSubscribe");
        resultMap.put("skillType", "1");
        resultMap.put("id", UUID.randomUUID().toString());

        return resultMap;
    }
}
