package com.digiwin.athena.schedulemanager.core.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.MessageDigest;

/**
 * @author renwm
 * @date: 2020/4/29 19:15
 */
public final class SecurityUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);

    private static final String ALGORITHM = DWApplicationConfigUtils.getProperty("SecurityUtil.ALGORITHM");
    private static final String CIPHER_TRANSFORMATION = DWApplicationConfigUtils.getProperty("SecurityUtil.CIPHER_TRANSFORMATION");

    private SecurityUtil() {

    }

    /**
     * @param
     * @return 密钥 = "C40605DBA4C2D6D3FA353C7CA35752B9";
     * secretFile = "53FA99EB3E4DA6AFE37DBD06F366FB6B";
     * 解密后:fafdsfasf
     */
    public static String decodeAES(String secretFile) {
        byte[] result = {};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        try {
            Key key1 = new SecretKeySpec(Hex.decodeHex(secretKey), "AES");

            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(Cipher.DECRYPT_MODE, key1);
            result = cipher.doFinal(Hex.decodeHex(secretFile));
        } catch (Exception e) {
            LOGGER.error("字符串" + secretFile + "使用decodeAES解密请求失败", e);
        }

        return new String(result);
    }

    public static String getMd5Hex(String inputStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            return Hex.encodeHexString(md.digest(StringUtils.getBytesUtf8(inputStr)));
        } catch (Exception e) {
            LOGGER.error("字符串" + inputStr + "使用MD5加密返回hex失败", e);
        }
        return result;
    }
}
