package com.digiwin.athena.schedulemanager.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.config.IAMHostConfig;
import com.digiwin.athena.schedulemanager.core.constant.FieldNameConstant;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangww
 * @description: http调用工具类
 * @date 2021/4/9 11:48
 */
@Component("scheduleCustomHttpClient")
public class CustomHttpClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);

    //APP_TOKEN,改为APP_TK解决静态扫描漏洞问题
    private static final String APP_TK = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";

    private static final String  DO_POST_PREFIX = "doPost请求";

    private static final String  ERROR_5XX = "出现服务端5XX异常！";

    private static final String ERROR_UNKNOWN = "出现未知状态码异常！";

    @Autowired
    @Qualifier("schedule-sm-resttemplate")
    private RestTemplate restTemplate;

    @Autowired
    @Qualifier("scheduleIAMHostConfig")
    private IAMHostConfig iamHostConfig;

    public String doPost(String url, Map<String, Object> body, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        //规范要求下发请求在head中区分routerKey大小写，确保K8S能够识别和路由，但由于tomcat在接收请求时，会自动小写，解析时需要解析routerkey
        headers.set(FieldNameConstant.ROUTER_KEY, routerKey);
        if (StringUtil.isNotBlank(token)) {
            headers.set("token", token);
        }
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(body, headers);
        ResponseEntity<String> content;
        try {
            content = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        } catch (HttpClientErrorException e) {
            LOGGER.error(DO_POST_PREFIX + "请求[" + url + "]出现客户端4XX异常！报文体内容: " +  e.getResponseBodyAsString() , e);
            throw new DWRuntimeException(DO_POST_PREFIX + "[" + url + "]出现异常！");
        } catch (HttpServerErrorException e) {
            LOGGER.error(DO_POST_PREFIX + "[" + url + "]" + ERROR_5XX + "报文体内容: " +  e.getResponseBodyAsString() , e);
            throw new DWRuntimeException(DO_POST_PREFIX + "[" + url + "]" + ERROR_5XX);
        } catch (UnknownHttpStatusCodeException e) {
            LOGGER.error(DO_POST_PREFIX + "[" + url + "]" + ERROR_UNKNOWN + "报文体内容: " +  e.getResponseBodyAsString() , e);
            throw new DWRuntimeException(DO_POST_PREFIX + "[" + url + "]" + ERROR_UNKNOWN);
        }

        if (HttpStatus.OK != content.getStatusCode()) {
            throw new DWRuntimeException(DO_POST_PREFIX + ":" + url + "返回HttpStatus为" + content.getStatusCode());
        }
        return content.getBody();
    }

    public String getRealTimeTenantToken(String tenantId) {
        String uri = iamHostConfig.getIamAddr();
        //LOGGER.error("调用iam接口,uri :{}", uri);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", APP_TK);
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put(getHashkey(), "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        HttpEntity<?> httpEntity = new HttpEntity(param, headers);
        ResponseEntity<JSONObject> responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<JSONObject>() {
        }, param);
        JSONObject result = (JSONObject)responseEntity.getBody();
        String tenantToken = result.getString("token");
        if (StringUtils.isEmpty(tenantToken)) {
            LOGGER.error("调用iam接口,获取租户token异常");
            throw new RuntimeException(String.format("获取IAM集成账号租户token:%s接口异常", APP_TK));
        }
        return tenantToken;
    }
    private String getHashkey() {
        return StringUtils.join(ArrayUtils.toArray("pas", "swordHash"));
    }
}
