package com.digiwin.athena.schedulemanager.service.facade;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.schedulemanager.pojo.request.BatchScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.CrossReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleUpdateReq;

/**
 * @author zhangww
 * @description: 排程引擎业务处理核心类
 * @date 2022/4/25 17:45
 */
public interface IScheduleFacadeService {

    /**
     * 创建排程
     * @param rule
     * @return
     */
    void createSchedule(BatchScheduleReq rule);

    /**
     * 删除排程
     * @param rule
     * @return
     */
    void deleteSchedule(ScheduleReq rule);

    /**
     * 查询排程信息列表
     * @param rule
     * @return
     */
    JSONObject getSchedule(ScheduleReq rule);

    /**
     * 修改排程
     * @param rule
     * @param enableStatus
     * @return
     */
    void updateSchedule(ScheduleUpdateReq rule, String enableStatus);

    /**
     * 停止排程
     * @param rule
     * @return
     */
    void stopSchedule(ScheduleReq rule);

    /**
     * 启用排程
     * @param rule
     * @return
     */
    void startSchedule(ScheduleReq rule);

    /**
     * 跨租户删除排程
     * @param cross
     * @return
     */
    void deleteScheduleCross(CrossReq cross);
}
