package com.digiwin.athena.schedulemanager.core.dict;

import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangzhi@digiwin.com
 * @date 2022/4/14
 */
public final class TypeDict {

    private TypeDict(){}

    protected static final Map<Integer, String> HOLDER = new HashMap<>();

    static {
        HOLDER.put(ScheduleConstant.STOP, ScheduleConstant.SCHEDULE_DISABLE);
        HOLDER.put(ScheduleConstant.DELETE, ScheduleConstant.SCHEDULE_REMOVE);
        HOLDER.put(ScheduleConstant.START, ScheduleConstant.SCHEDULE_ENABLE);
    }

    public static String getMethodName(Integer type){
        return HOLDER.get(type);
    }
}
