package com.digiwin.athena.schedulemanager.core.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;

/**
 * @description: 无需再次重试的自定义异常的父类
 * @author: dongwh
 * @date: 2022/1/7 16:06
 */
public class UnRetryAbleException extends DWRuntimeException {

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public UnRetryAbleException(String message) {
        super(message);
    }

    public UnRetryAbleException(String errorCode, String message) {
        super(errorCode, message);
    }
}
