package com.digiwin.athena.schedulemanager.provider;

import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler;
import com.digiwin.athena.schedulemanager.core.aop.RouterKey;
import com.digiwin.athena.schedulemanager.core.constant.FieldNameConstant;
import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.producer.MessageProducer;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: 排程对外job服务
 * @author: zhangww
 * @time: 2020/4/16 11:51
 */
@Service("scheduleExecuteService")
@MyExceptionHandler
public class ExecuteService implements IExecuteService {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteService.class);

    private MessageProducer rabbitMQProducer;

    private IScheduleDefineService defineService;

    public ExecuteService(MessageProducer rabbitMQProducer,
        IScheduleDefineService defineService) {
        this.rabbitMQProducer = rabbitMQProducer;
        this.defineService = defineService;
    }

    @Override
    @RouterKey
    public DWJobResult post(Map<String, Object> paramMap) {
        return executeJob(paramMap);
    }

    @Override
    public DWJobResult postExecuteRemoteJob(Map<String, Object> param) {
        DWJobResult result = new DWJobResult();
        //发送MQ
        String messageBody = sendMessage(param);
        result.setMessage(messageBody);
        result.setExecuteStatus(DWJobResult.OK);
        LOGGER.info("remoteJob排程接收到消息发送到MQ：{}, routerKey：{}", param, DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.ROUTER_KEY));
        return result;
    }

    @Override
    public DWJobResult executeJob(Map<String, Object> paramMap) {
        String ruleId = paramMap.get(ScheduleConstant.RULEID) == null ? "" : String.valueOf(paramMap.get(ScheduleConstant.RULEID));
        String instanceId = paramMap.get(ScheduleConstant.INSTANCE_ID) == null ? "" : String.valueOf(paramMap.get(ScheduleConstant.INSTANCE_ID));
        //缺少实例数据的为老数据不做校验
        if (!StringUtil.isEmpty(ruleId) && !StringUtil.isEmpty(instanceId) && defineService.isNotExist(ruleId, instanceId)) {
            //加了有效性校验后新增的数据做有效性校验
            LOGGER.error("存在无效的排程: {}", paramMap);
            return null;
        }

        DWJobResult result = new DWJobResult();
        //发送MQ
        String messageBody = sendMessage(paramMap);
        result.setMessage(messageBody);
        result.setExecuteStatus(DWJobResult.OK);
        LOGGER.info("job排程接收到消息发送到MQ：{}, routerKey：{}", paramMap, DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.ROUTER_KEY));
        return result;
    }

    /**
     * 发送MQ消息
     * @param paramMap
     * @return
     */
    private String sendMessage(Map<String, Object> paramMap) {
        String messageId = rabbitMQProducer.sendMessage(paramMap);
        paramMap.put(ScheduleConstant.MESSAGE_ID, messageId);
        return JsonUtil.getJsonString(paramMap);
    }
}
