package com.digiwin.athena.schedulemanager.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.schedulemanager.pojo.request.BatchScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleReq;
import com.digiwin.athena.schedulemanager.pojo.request.ScheduleUpdateReq;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;

/**
 * @author zhangww
 * @description:
 * @date 2022/4/25 16:48
 */
@DWRestfulService
@Validated
public interface IScheduleOpsService extends DWService {

    /**
     * 创建排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule", method = DWRequestMethod.POST)
    void create(@Valid BatchScheduleReq rule);

    /**
     * 删除排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule", method = DWRequestMethod.DELETE)
    void delete(@Valid ScheduleReq rule);

    /**
     * 查询排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule/query", method = DWRequestMethod.POST)
    JSONObject getSchedule(@Valid ScheduleReq rule);

    /**
     * 更新排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule", method = DWRequestMethod.PUT)
    void edit(@Valid ScheduleUpdateReq rule);

    /**
     * 停止排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule/stop", method = DWRequestMethod.POST)
    void stop(@Valid ScheduleReq rule);

    /**
     * 启用排程
     * @param rule
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/schedule/start", method = DWRequestMethod.POST)
    void start(@Valid ScheduleReq rule);
}
