package com.digiwin.athena.schedulemanager.service.srp.impl;

import com.digiwin.athena.schedulemanager.repository.dao.IScheduleDefineDao;
import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;
import com.digiwin.athena.schedulemanager.service.srp.IScheduleDefineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhangww
 * @description: 排程定义服务
 * @date 2021/10/20 10:47
 */
@Service("scheduleDefineService")
public class ScheduleDefineService implements IScheduleDefineService {

    @Autowired
    private IScheduleDefineDao defineDao;

    /**
     * 保存排程定义
     * @param model
     */
    @Override
    public void saveScheduleDefine(ScheduleDetailModel model) {
        defineDao.saveScheduleDefine(model);
    }

    /**
     * 删除排程定义
     * @param instanceId
     */
    @Override
    public void deleteScheduleDefine(String instanceId) {
        defineDao.deleteScheduleDefine(instanceId);
    }

    /**
     * 更新trigger信息
     * @param trigger
     * @param instanceId
     * @return
     */
    @Override
    public int updateTrigger(String trigger, String instanceId) {
        return defineDao.updateTrigger(trigger, instanceId);
    }

    /**
     * 根据规则id获取排程信息
     * @param ruleId
     * @return
     */
    @Override
    public List<ScheduleDetailModel> getScheduleInfoByRuleId(String ruleId) {
        return defineDao.getScheduleInfoByRuleId(ruleId);
    }

    /**
     * 根据规则id获取排程信息(已经被置为无效)
     * @param ruleId
     * @return
     */
    @Override
    public List<ScheduleDetailModel> getValidScheduleInfoByRuleId(String ruleId) {
        return defineDao.getValidScheduleInfoByRuleId(ruleId);
    }

    /**
     * 根据ruleId和instanceId查询是否存在对应有效的排程
     * @param ruleId
     * @param instanceId
     * @return
     */
    @Override
    public boolean isNotExist(String ruleId, String instanceId) {
        return defineDao.isNotExist(ruleId, instanceId);
    }
}
