package com.digiwin.athena.schedulemanager.core.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * jdk8 LocalTime LocalDate localDateTime等时间类的转换操作
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/9/24
 */
public final class LocalTimeUtil {

    private LocalTimeUtil() {

    }

    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    private static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);

    /**
     * 获取当前时间,不包含毫秒
     * @return
     */
    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DATETIME_FMT_BY_DATE_AND_TIME);
    }
}
