package com.digiwin.athena.schedulemanager.service.client;

import com.digiwin.athena.schedulemanager.pojo.request.CrossReq;

import java.util.List;
import java.util.Map;

/**
 * @author zhangww
 * @description: 平台排程api处理类
 * @date 2021/10/21 14:06
 */
public interface IDwScheduleClient {

    /**
     * 创建或修改排程
     * @param scheduleParamList
     * @param methodName
     * @return
     */
    String addQuartz(List<Map<String, Object>> scheduleParamList, String methodName);

    /**
     * 启用停用或删除排程
     * @param scheduleIdList
     * @param methodName
     * @return
     */
    String executeQuartz(List<String> scheduleIdList, String methodName);

    /**
     * 获取排程
     * @param scheduleIdList
     * @return
     */
    String getQuartz(List<String> scheduleIdList);

    /**
     * 跨租户删除排程
     * @param cross
     * @return
     */
    String deleteQuartzCross(CrossReq cross);
}
