package com.digiwin.athena.schedulemanager.service.client.impl;

import com.digiwin.app.serviceclient.ServiceClient;
import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import com.digiwin.athena.schedulemanager.pojo.request.CrossReq;
import com.digiwin.athena.schedulemanager.service.client.IDwScheduleClient;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 平台排程api处理类
 * @author: zhangww
 * @time: 2020/4/14 09:57
 */
@Component("scheduleDwScheduleClient")
public class DwScheduleClient implements IDwScheduleClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DwScheduleClient.class);
    @Override
    public String addQuartz(List<Map<String, Object>> scheduleParamList, String methodName){
        LOGGER.info("请求参数为[{}],方法为[{}]进行排程处理", JsonUtil.getJsonString(scheduleParamList), methodName);
        Map<String, Object> param = new HashMap<>(ScheduleConstant.CAPACITY_1);
        param.put(ScheduleConstant.PARAMMAP, scheduleParamList);
        String result = executeRemote(param, methodName);
        LOGGER.info("调用排程结果：{}", result);
        return result;
    }

    @Override
    public String executeQuartz(List<String> scheduleIdList, String methodName) {
        LOGGER.info("请求参数为[{}],方法为[{}]进行排程处理", JsonUtil.getJsonString(scheduleIdList), methodName);
        Map<String, Object> param = new HashMap<>(ScheduleConstant.CAPACITY_1);
        param.put(ScheduleConstant.SCHEDULEIDLIST, scheduleIdList);
        String result = executeRemote(param, methodName);
        LOGGER.info("调用排程结果：{}", result);
        return result;
    }

    /**
     * 查询排程信息
     * @param scheduleIdList
     * @return
     * @throws Exception
     */
    @Override
    public String getQuartz(List<String> scheduleIdList) {
        LOGGER.info("调用api查询排程：{}", scheduleIdList);
        Map<String, Object> param = new HashMap<>(ScheduleConstant.CAPACITY_1);
        param.put(ScheduleConstant.SCHEDULE_IDS, scheduleIdList);
        String result = executeRemote(param, ScheduleConstant.SCHEDULE_GETINFO);
        LOGGER.info("查询排程结果：{}", result);
        return result;
    }

    @Override
    public String deleteQuartzCross(CrossReq cross) {
        LOGGER.info("调用api跨租户删除排程：{}", cross);
        Map<String, Object> param = new HashMap<>(ScheduleConstant.CAPACITY_1);
        param.put(ScheduleConstant.PARAMMAP, cross.getParamMap());
        String result = executeRemote(param, ScheduleConstant.SCHEDULE_REMOVE_CROSS);
        LOGGER.info("调用api跨租户删除排程结果：{}", result);
        return result;
    }

    /**
     * 执行远程服务
     * @param param
     * @param method
     * @return
     * @throws Exception
     */
    private String executeRemote(Map<String, Object> param, String method) {
        return new ServiceClient().invokeThisDapService(ScheduleConstant.DWSYS, ScheduleConstant.SCHEDULE_SERVICENAME, method, param);
    }

}