package com.digiwin.athena.schedulemanager.service.srp;

import com.digiwin.athena.schedulemanager.repository.model.ScheduleDetailModel;

import java.util.List;

/**
 * @author zhangww
 * @description: 排程定义服务
 * @date 2021/10/20 10:43
 */
public interface IScheduleDefineService {

    /**
     * 保存排程定义
     * @param model
     */
    void saveScheduleDefine(ScheduleDetailModel model);

    /**
     * 删除排程定义
     * @param instanceId
     */
    void deleteScheduleDefine(String instanceId);

    /**
     * 更新trigger信息
     * @param trigger
     * @param instanceId
     * @return
     */
    int updateTrigger(String trigger, String instanceId);

    /**
     * 根据规则id获取排程信息
     * @param ruleId
     * @return
     */
    List<ScheduleDetailModel> getScheduleInfoByRuleId(String ruleId);

    /**
     * 根据规则id获取排程信息
     * @param ruleId
     * @return
     */
    List<ScheduleDetailModel> getValidScheduleInfoByRuleId(String ruleId);

    /**
     * 查询是否存在对应有效的排程
     * @param ruleId
     * @param instanceId
     * @return
     */
    boolean isNotExist(String ruleId, String instanceId);
}
