package com.digiwin.athena.schedulemanager.service.srp.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.schedulemanager.core.constant.FieldNameConstant;
import com.digiwin.athena.schedulemanager.core.constant.ScheduleConstant;
import com.digiwin.athena.schedulemanager.core.constant.StaticConfig;
import com.digiwin.athena.schedulemanager.core.exception.BusinessException;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.core.util.CollectionUtil;
import com.digiwin.athena.schedulemanager.core.util.SecurityUtil;
import com.digiwin.athena.schedulemanager.core.util.StringUtil;
import com.digiwin.athena.schedulemanager.service.client.impl.CustomHttpClient;
import com.digiwin.athena.schedulemanager.util.JsonUtil;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 租户相关服务
 * * @author: renwm
 * * @date: 2020/4/26 15:59
 */
@Service("scheduleTenantService")
public class TenantService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TenantService.class);

    @Autowired
    @Qualifier("scheduleCustomHttpClient")
    private CustomHttpClient httpClient;

    /**
     * LicenseKey的requestFrom
     */
    public static final String LICENSEKEY_REQUEST_FROM = "requestFrom";
    /**
     * LicenseKey的timestamp
     */
    public static final String LICENSEKEY_TIMESTAMP = "timestamp";
    /**
     * LicenseKey的key
     */
    public static final String LICENSEKEY_KEY = "key";


    private static final String PASSWORD_HASH = DWApplicationConfigUtils.getProperty("schedule.IamClient.PASSWORD_HASH");

    /**
     * 获取租户的TenantSid
     *
     * @param tenantId
     * @return
     * @throws Exception
     */
    private String getUserTenantSid(String tenantId) {
//        // 获取租户对应的授权码
//        String secretKey = getTenantSecretKey(tenantId);
//        // 获取登录用户信息
//        Map<String, Object> iamResult = getLoginResponse(secretKey);
//        if (MapUtils.isEmpty(iamResult)) {
//            return "";
//        }

        Map<String, Object> iamResult = this.identityLogin(tenantId);
        return MapUtils.getString(iamResult, ScheduleConstant.TENANT_SID);
    }

//    /**
//     * 获取登录用户信息
//     * @return
//     */
//    private Map<String, Object> getLoginResponse(String secretKey) {
//        Map<String, Object> paramMap = new HashMap<>(ScheduleConstant.CAPACITY_4);
//        paramMap.put(FieldNameConstant.SECRETKEY_KEY, secretKey);
//        paramMap.put(FieldNameConstant.IDENTITY_TYPE_KEY, StaticConfig.IAM_IDENTITYTYPE);
//
//        ServiceModel iamModel = new ServiceModel();
//        iamModel.setInvokeURL(StaticConfig.IAM_USERLOGINURL);
//        iamModel.setParams(paramMap);
//        iamModel.setRequestMethod(DWRequestMethod.POST);
//        HttpResponseModel responseModel;
//        try {
//            responseModel = (HttpResponseModel) IAMService.invoke(iamModel);
//        }catch (Exception e){
//            LOGGER.error("获取租户登录信息异常", e);
//            throw new DWRuntimeException(ErrorCode.ERROR_LOGIN_CODE.getCode(), ErrorCode.ERROR_LOGIN_CODE.getMessage());
//        }
//
//        if (ScheduleConstant.HTTP_RESPONSE_SUCCESS_STATUS == responseModel.getHttpStatusCode()) {
//            return JSONObject.parseObject(responseModel.getResponseBody());
//        }
//        return null;
//    }

    /**
     * 根据租户获取集成账号信息
     *
     * @param tenantId 租户id
     */
    private Map<String, Object> identityLogin(String tenantId) {

        Map<String, Object> paramMap = new HashMap<>(ScheduleConstant.CAPACITY_4);
        paramMap.put("tenantId", tenantId);
        paramMap.put("identityType", "internal");
        paramMap.put("userId", "integration");
        paramMap.put(getMapKey(), PASSWORD_HASH);

        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL(StaticConfig.IAM_USERLOGINURL);
        iamModel.setParams(paramMap);
        iamModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel responseModel;
        try {
            responseModel = (HttpResponseModel) IAMService.invoke(iamModel);
            LOGGER.info("获取租户登录信息 = {}", responseModel);
        } catch (Exception e) {
            LOGGER.error("获取租户登录信息异常", e);
            throw new DWRuntimeException(ErrorCode.ERROR_LOGIN_CODE.getCode(), ErrorCode.ERROR_LOGIN_CODE.getMessage());
        }

        if (ScheduleConstant.HTTP_RESPONSE_SUCCESS_STATUS == responseModel.getHttpStatusCode()) {
            return JSONObject.parseObject(responseModel.getResponseBody());
        }
        return null;
    }
    private String getMapKey(){
        return  "pas"+"swordHash";
    }
    /**
     * 求取LicenseKey入参
     *
     * @param tenantId
     * @return
     */
    private Map<String, Object> licenseKeyParam(String tenantId) {
        Map<String, Object> param = new HashMap<>(8);
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String key = SecurityUtil.getMd5Hex(sb.append(tenantId).append(StaticConfig.THEMEMAP_LICENSEKEY_REQUEST_FROM).append(timestamp).append(StaticConfig.THEMEMAP_LICENSEKEY_MD5_KEY).toString());
        param.put(ScheduleConstant.TENANTID, tenantId);
        param.put(LICENSEKEY_REQUEST_FROM, StaticConfig.THEMEMAP_LICENSEKEY_REQUEST_FROM);
        param.put(LICENSEKEY_TIMESTAMP, timestamp);
        param.put(LICENSEKEY_KEY, key);
        return param;
    }

    /**
     * 获取租户对应的授权码
     *
     * @param tenantId
     * @return
     */
    private String getTenantSecretKey(String tenantId) {
        Map<String, Object> licenseKeyParam = licenseKeyParam(tenantId);
        String httpResp = httpClient.doPost(StaticConfig.THEMEMAP_LICENSEKEY_URL, licenseKeyParam, DWServiceContext.getContext().getToken(), tenantId);
        JSONObject httpRespOjb = JsonUtil.getObject(httpResp);

        if (CollectionUtil.isNotEmpty(httpRespOjb) && ScheduleConstant.HTTP_RESPONSE_SUCCESS_STATUS == httpRespOjb.getIntValue(FieldNameConstant.DW_SERVICE_STATUS)) {
            LOGGER.info("排程调用km获取LicenseKey成功！");
            String data = httpRespOjb.getString(FieldNameConstant.DW_SERVICE_RESPONSE);
            if (StringUtil.isEmpty(data)) {
                throw new BusinessException(ErrorCode.PARAM_LICENSE_KEY_KEY_EMPTY_CODE);
            }
            return SecurityUtil.decodeAES(data);
        } else {
            LOGGER.error("排程调用ThemeMap获取LicenseKey异常，返回结果为[{}]", httpRespOjb);
            throw new BusinessException(ErrorCode.PARAM_KM_LICENSE_KEY_EMPTY_CODE);
        }
    }

    /**
     * 获取profile信息 内含tenantSid，调用dao方法的时候需要校验上下文tenantSid
     *
     * @param tenantId
     * @return
     * @throws Exception
     */
    @Retryable(value = {DWRuntimeException.class}, backoff = @Backoff(delay = 1000L, multiplier = 1.5))
    public Map<String, Object> getProfile(String tenantId) {
        Map<String, Object> profileMap = new HashMap<>(ScheduleConstant.CAPACITY_1);

        // 获取租户tenantSid
        String tenantSid = getUserTenantSid(tenantId);
        if (StringUtil.isNotBlank(tenantSid)) {
            profileMap.put(ScheduleConstant.TENANT_SID, Long.parseLong(tenantSid));
        }

        return profileMap;
    }
}
