/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.core.config;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.filter.DWResultSetFilterChain;
import com.digiwin.app.dao.filter.IDWResultSetFilter;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.athena.schedulemanager.core.config.ScheduleDWDefaultDWDaoEnableCondition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DWQueryTimeoutQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
public class ScheduleCommonDBConfig {
    @Bean(name={"schedule-dw-transactionManager"})
    @ConditionalOnBean(name={"schedule-dataSource"})
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier(value="schedule-proxyDataSource") DataSource dataSourceProxy) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSourceProxy);
        return dataSourceTransactionManager;
    }

    @Bean(name={"schedule-dataSource"})
    @Conditional(value={ScheduleDWDefaultDWDaoEnableCondition.class})
    @ConfigurationProperties(value="spring.datasource.schedule")
    public DataSource defaultDWDaoDataSource(ApplicationContext context) {
        String datasourceUrl = context.getEnvironment().getProperty("spring.datasource.schedule.url");
        if (StringUtils.isBlank((CharSequence)datasourceUrl)) {
            PropertySource propertySource;
            String datasourceUrlType = context.getEnvironment().getProperty("spring.datasource.schedule.url.type");
            String datasourceUrlHost = context.getEnvironment().getProperty("spring.datasource.schedule.url.host");
            String datasourceUrlPort = context.getEnvironment().getProperty("spring.datasource.schedule.url.port");
            String datasourceUrlDatabase = context.getEnvironment().getProperty("spring.datasource.schedule.url.database");
            String datasourceUrlArgs = context.getEnvironment().getProperty("spring.datasource.schedule.url.args");
            StringBuilder datasourceUrlCombination = new StringBuilder();
            datasourceUrlCombination.append("jdbc:" + datasourceUrlType + "://" + datasourceUrlHost);
            if (!"".equals(datasourceUrlPort)) {
                datasourceUrlCombination.append(":" + datasourceUrlPort);
            }
            datasourceUrlCombination.append("/" + datasourceUrlDatabase);
            if (!"".equals(datasourceUrlArgs)) {
                datasourceUrlCombination.append("?" + datasourceUrlArgs);
            }
            if ((propertySource = ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().get("dap-application-propertysource")) instanceof EnumerablePropertySource) {
                Properties properties = new Properties();
                properties.put("spring.datasource.schedule.url", datasourceUrlCombination.toString());
                EnumerablePropertySource<Properties> scheduleUrlPropertySource = new EnumerablePropertySource<Properties>("dap-dao-schedule-dynamic-propertysource", properties){

                    public Object getProperty(String name) {
                        return ((Properties)this.getSource()).getProperty(name);
                    }

                    public String[] getPropertyNames() {
                        ArrayList<String> propertyNames = new ArrayList<String>();
                        Enumeration<Object> sourcesKeys = ((Properties)this.getSource()).keys();
                        while (sourcesKeys.hasMoreElements()) {
                            String key = (String)sourcesKeys.nextElement();
                            propertyNames.add(key);
                        }
                        return propertyNames.toArray(new String[propertyNames.size()]);
                    }
                };
                ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().addFirst((PropertySource)scheduleUrlPropertySource);
            }
        }
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"spring.datasource.schedule");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSourceBuilder dataSourceBuilder = ((DataSourceProperties)result.get()).initializeDataSourceBuilder();
        return dataSourceBuilder.build();
    }

    @Bean(name={"schedule-proxyDataSource"})
    @ConditionalOnBean(name={"schedule-dataSource"})
    public TransactionAwareDataSourceProxy transactionAwareDataSourceProxy(@Qualifier(value="schedule-dataSource") DataSource dataSource) {
        TransactionAwareDataSourceProxy returnDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
        return returnDataSourceProxy;
    }

    @Bean(name={"schedule-queryRunner"})
    @ConditionalOnBean(name={"schedule-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="schedule-proxyDataSource") DataSource dataSourceProxy) {
        return new DWQueryTimeoutQueryRunner(dataSourceProxy);
    }

    private DWSQLDialect dwSqlDialect(Environment environment) throws Exception {
        DWMySQLDialect dialect = null;
        String dialectClassName = environment.getProperty("spring.datasource.schedule.dialect.class");
        if (dialectClassName == null) {
            dialect = new DWMySQLDialect();
        } else {
            Class<?> dialectClass = this.getClass().getClassLoader().loadClass(dialectClassName);
            dialect = (DWSQLDialect)dialectClass.newInstance();
        }
        return dialect;
    }

    @Bean(name={"schedule-dao"})
    @ConditionalOnBean(name={"schedule-queryRunner"})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="schedule-queryRunner") QueryRunner queryRunner, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties, @Qualifier(value="dw-dao-properties") DWDaoProperties daoProperties, Environment environment) throws Exception {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        dao.setDialect(this.dwSqlDialect(environment));
        dao.setProperties(daoProperties);
        boolean mapUnderscoreToCamelCase = true;
        boolean settingValue = dataSourceProperties.isDwDaoUnderScoreToCamelCase();
        if (!settingValue) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        boolean insertDefaultValueFromMetadata = daoProperties.getDataSetProperties().isDwdaoInsertDefaultValueFromMetadata();
        dao.setInsertDefaultValueFromMetadata(insertDefaultValueFromMetadata);
        boolean updateDefaultValueFromMetadata = daoProperties.getDataSetProperties().isDwdaoUpdateDefaultValueFromMetadata();
        dao.setUpdateDefaultValueFromMetadata(updateDefaultValueFromMetadata);
        dao.setQueryPaginationByObjectEnabled(daoProperties.getDataSetProperties().isQueryPaginationByObjectEnabled());
        ArrayList<IDWResultSetFilter> resultSetFilters = new ArrayList<IDWResultSetFilter>();
        String resultSetFilterClassNames = daoProperties.getDaoResultSetFilterProperties().getResultSetFilterClassNames();
        if (resultSetFilterClassNames != null && !"".equals(resultSetFilterClassNames)) {
            String[] classNames;
            for (String className : classNames = resultSetFilterClassNames.split(",")) {
                Class resultSetFilterClass = DWApplicationClassLoader.getInstance().loadClass(className);
                resultSetFilters.add((IDWResultSetFilter)resultSetFilterClass.newInstance());
            }
        }
        DWResultSetFilterChain resultSetFilterChain = new DWResultSetFilterChain(resultSetFilters);
        dao.setDWResultSetFilter((IDWResultSetFilter)resultSetFilterChain);
        return dao;
    }
}

