/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.schedulemanager.provider;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.schedulemanager.core.aop.MyExceptionHandler;
import com.digiwin.athena.schedulemanager.core.aop.RouterKey;
import com.digiwin.athena.schedulemanager.core.message.ErrorCode;
import com.digiwin.athena.schedulemanager.pojo.request.OpsScheduleReq;
import com.digiwin.athena.schedulemanager.provider.IDevOpsService;
import com.digiwin.athena.schedulemanager.service.facade.IOpsFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="scheduleDevOpsService")
@MyExceptionHandler
public class DevOpsService
implements IDevOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevOpsService.class);
    private IOpsFacadeService service;

    public DevOpsService(IOpsFacadeService service) {
        this.service = service;
    }

    @Override
    @RouterKey
    public void clearDirtyData(OpsScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u5220\u9664\u65e0\u6548\u7684\u6392\u7a0b\uff1a{}", (Object)rule);
        if (null == rule) {
            throw new DWRuntimeException(ErrorCode.PARAM_RULE_EMPTY_CODE.getCode(), ErrorCode.PARAM_RULE_EMPTY_CODE.getMessage());
        }
        this.service.deleteInvalidSchedule(rule);
    }
}

